/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.org.meteordev.starscript;

import craftpresence.external.org.meteordev.starscript.Starscript;
import craftpresence.external.org.meteordev.starscript.utils.SFunction;
import craftpresence.external.org.meteordev.starscript.value.Value;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.function.Supplier;

public class StandardLib {
    private static final Random rand = new Random();
    public static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd. MM. yyyy");

    public static void init(Starscript ss) {
        ss.set("PI", Math.PI);
        ss.set("time", (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$init$0(), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("date", (Supplier<Value>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$init$1(), ()Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("round", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, round(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("roundToString", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, roundToString(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("floor", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, floor(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("ceil", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, ceil(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("abs", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, abs(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("random", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, random(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("string", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, string(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("toUpper", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, toUpper(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("toLower", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, toLower(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("contains", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, contains(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("replace", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, replace(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
        ss.set("pad", (SFunction)LambdaMetafactory.metafactory(null, null, null, (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;, pad(craftpresence.external.org.meteordev.starscript.Starscript int ), (Lcraftpresence/external/org/meteordev/starscript/Starscript;I)Lcraftpresence/external/org/meteordev/starscript/value/Value;)());
    }

    public static Value round(Starscript ss, int argCount) {
        if (argCount == 1) {
            double a = ss.popNumber("Argument to round() needs to be a number.");
            return Value.number(Math.round(a));
        }
        if (argCount == 2) {
            double b = ss.popNumber("Second argument to round() needs to be a number.");
            double a = ss.popNumber("First argument to round() needs to be a number.");
            double x = Math.pow(10.0, (int)b);
            return Value.number((double)Math.round(a * x) / x);
        }
        ss.error("round() requires 1 or 2 arguments, got %d.", argCount);
        return null;
    }

    public static Value roundToString(Starscript ss, int argCount) {
        if (argCount == 1) {
            double a = ss.popNumber("Argument to round() needs to be a number.");
            return Value.string(Double.toString(Math.round(a)));
        }
        if (argCount == 2) {
            double b = ss.popNumber("Second argument to round() needs to be a number.");
            double a = ss.popNumber("First argument to round() needs to be a number.");
            double x = Math.pow(10.0, (int)b);
            return Value.string(Double.toString((double)Math.round(a * x) / x));
        }
        ss.error("round() requires 1 or 2 arguments, got %d.", argCount);
        return null;
    }

    public static Value floor(Starscript ss, int argCount) {
        if (argCount != 1) {
            ss.error("floor() requires 1 argument, got %d.", argCount);
        }
        double a = ss.popNumber("Argument to floor() needs to be a number.");
        return Value.number(Math.floor(a));
    }

    public static Value ceil(Starscript ss, int argCount) {
        if (argCount != 1) {
            ss.error("ceil() requires 1 argument, got %d.", argCount);
        }
        double a = ss.popNumber("Argument to ceil() needs to be a number.");
        return Value.number(Math.ceil(a));
    }

    public static Value abs(Starscript ss, int argCount) {
        if (argCount != 1) {
            ss.error("abs() requires 1 argument, got %d.", argCount);
        }
        double a = ss.popNumber("Argument to abs() needs to be a number.");
        return Value.number(Math.abs(a));
    }

    public static Value random(Starscript ss, int argCount) {
        if (argCount == 0) {
            return Value.number(rand.nextDouble());
        }
        if (argCount == 2) {
            double max = ss.popNumber("Second argument to random() needs to be a number.");
            double min = ss.popNumber("First argument to random() needs to be a number.");
            return Value.number(min + (max - min) * rand.nextDouble());
        }
        ss.error("random() requires 0 or 2 arguments, got %d.", argCount);
        return Value.null_();
    }

    private static Value string(Starscript ss, int argCount) {
        if (argCount != 1) {
            ss.error("string() requires 1 argument, got %d.", argCount);
        }
        return Value.string(ss.pop().toString());
    }

    public static Value toUpper(Starscript ss, int argCount) {
        if (argCount != 1) {
            ss.error("toUpper() requires 1 argument, got %d.", argCount);
        }
        String a = ss.popString("Argument to toUpper() needs to be a string.");
        return Value.string(a.toUpperCase());
    }

    public static Value toLower(Starscript ss, int argCount) {
        if (argCount != 1) {
            ss.error("toLower() requires 1 argument, got %d.", argCount);
        }
        String a = ss.popString("Argument to toLower() needs to be a string.");
        return Value.string(a.toLowerCase());
    }

    public static Value contains(Starscript ss, int argCount) {
        if (argCount != 2) {
            ss.error("replace() requires 2 arguments, got %d.", argCount);
        }
        String search = ss.popString("Second argument to contains() needs to be a string.");
        String string = ss.popString("First argument to contains() needs to be a string.");
        return Value.bool(string.contains(search));
    }

    public static Value replace(Starscript ss, int argCount) {
        if (argCount != 3) {
            ss.error("replace() requires 3 arguments, got %d.", argCount);
        }
        String to2 = ss.popString("Third argument to replace() needs to be a string.");
        String from = ss.popString("Second argument to replace() needs to be a string.");
        String string = ss.popString("First argument to replace() needs to be a string.");
        return Value.string(string.replace(from, to2));
    }

    public static Value pad(Starscript ss, int argCount) {
        if (argCount != 2) {
            ss.error("pad() requires 2 arguments, got %d.", argCount);
        }
        int width = (int)ss.popNumber("Second argument to pad() needs to be a number.");
        String text = ss.pop().toString();
        if (text.length() >= Math.abs(width)) {
            return Value.string(text);
        }
        char[] padded = new char[Math.max(text.length(), Math.abs(width))];
        if (width >= 0) {
            int i;
            int padLength = width - text.length();
            for (i = 0; i < padLength; ++i) {
                padded[i] = 32;
            }
            for (i = 0; i < text.length(); ++i) {
                padded[padLength + i] = text.charAt(i);
            }
        } else {
            int i;
            for (i = 0; i < text.length(); ++i) {
                padded[i] = text.charAt(i);
            }
            for (i = 0; i < Math.abs(width) - text.length(); ++i) {
                padded[text.length() + i] = 32;
            }
        }
        return Value.string(new String(padded));
    }

    private static /* synthetic */ Value lambda$init$1() {
        return Value.string(dateFormat.format(new Date()));
    }

    private static /* synthetic */ Value lambda$init$0() {
        return Value.string(timeFormat.format(new Date()));
    }
}

