/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.hypherionmc.moonconfig.core.Config;
import me.hypherionmc.moonconfig.core.file.FileNotFoundAction;
import me.hypherionmc.moonconfig.core.io.ConfigParser;
import me.hypherionmc.moonconfig.core.io.ParsingMode;
import me.hypherionmc.moonconfig.core.io.WritingException;
import me.hypherionmc.moonconfig.core.utils.FastStringReader;

public static class ConfigParser$jvmdg$StaticDefaults {
    public static C parse(ConfigParser this_, String input) {
        return this_.parse(new FastStringReader(input));
    }

    public static void parse(ConfigParser this_, String input, Config destination, ParsingMode parsingMode) {
        this_.parse(new StringReader(input), destination, parsingMode);
    }

    public static C parse(ConfigParser this_, InputStream input) {
        return this_.parse(input, StandardCharsets.UTF_8);
    }

    public static C parse(ConfigParser this_, InputStream input, Charset charset) {
        return this_.parse(new BufferedReader(new InputStreamReader(input, charset)));
    }

    public static void parse(ConfigParser this_, InputStream input, Config destination, ParsingMode parsingMode) {
        this_.parse(input, destination, parsingMode, StandardCharsets.UTF_8);
    }

    public static void parse(ConfigParser this_, InputStream input, Config destination, ParsingMode parsingMode, Charset charset) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));
        this_.parse(reader, destination, parsingMode);
    }

    public static C parse(ConfigParser this_, File file, FileNotFoundAction nefAction) {
        return this_.parse(file, nefAction, StandardCharsets.UTF_8);
    }

    public static C parse(ConfigParser this_, File file, FileNotFoundAction nefAction, Charset charset) {
        return this_.parse(file.toPath(), nefAction, charset);
    }

    public static void parse(ConfigParser this_, File file, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction) {
        this_.parse(file, destination, parsingMode, nefAction, StandardCharsets.UTF_8);
    }

    public static void parse(ConfigParser this_, File file, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction, Charset charset) {
        this_.parse(file.toPath(), destination, parsingMode, nefAction, charset);
    }

    public static C parse(ConfigParser this_, Path file, FileNotFoundAction nefAction) {
        return this_.parse(file, nefAction, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static C parse(ConfigParser this_, Path file, FileNotFoundAction nefAction, Charset charset) {
        try {
            if (Files.notExists(file, new LinkOption[0]) && !nefAction.run(file, this_.getFormat())) {
                return this_.getFormat().createConfig();
            }
            try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                Object c = this_.parse(input, charset);
                return c;
            }
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    public static void parse(ConfigParser this_, Path file, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction) {
        this_.parse(file, destination, parsingMode, nefAction, StandardCharsets.UTF_8);
    }

    public static void parse(ConfigParser this_, Path file, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction, Charset charset) {
        try {
            if (Files.notExists(file, new LinkOption[0]) && !nefAction.run(file, this_.getFormat())) {
                return;
            }
            try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                this_.parse(input, destination, parsingMode, charset);
            }
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static C parse(ConfigParser this_, URL url) {
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new WritingException("Unable to connect to the URL", e);
        }
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));){
            Object c = this_.parse(reader);
            return c;
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    public static void parse(ConfigParser this_, URL url, Config destination, ParsingMode parsingMode) {
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new WritingException("Unable to connect to the URL", e);
        }
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));){
            this_.parse(reader, destination, parsingMode);
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }
}

