/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.migration;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.config.migration.DataMigrator;
import com.google.gson.JsonElement;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import craftpresence.external.me.hypherionmc.moonconfig.core.AbstractConfig;
import craftpresence.external.me.hypherionmc.moonconfig.core.UnmodifiableConfig;
import craftpresence.external.me.hypherionmc.moonconfig.core.file.FileConfig;
import craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ConfigFlag.class})
public class HypherConverter
implements DataMigrator {
    private static final Pattern EXPR_PATTERN = Pattern.compile("\\{(.*?)}");
    private static final int LOWEST_SUPPORTED = 13;
    private static final int HIGHEST_SUPPORTED = 26;
    private final int fileVersion;
    private final String configPath;
    private final String serverEntriesPath;
    private final String replayModPath;
    private final Map<String, String> placeholderMappings = new HashMapBuilder().put((Object)"%player%", (Object)"{player.name}").put((Object)"%world%", (Object)"{dimension.name}").put((Object)"%mods%", (Object)"{general.mods}").put((Object)"%difficulty%", (Object)"{world.difficulty}").put((Object)"%position%", (Object)"{'x: ' + player.position.x + ', y: ' + player.position.y + ', z: ' + player.position.z}").put((Object)"%biome%", (Object)"{biome.name}").put((Object)"%mcver%", (Object)"{general.version}").put((Object)"%instance%", (Object)"{pack.name}").put((Object)"%launcher%", (Object)"{general.brand}").put((Object)"%server%", (Object)"{replace(server.address.short, '.', '_')}").put((Object)"%launchername%", (Object)"{toLower(general.brand)}").put((Object)"%savename%", (Object)"{world.name}").put((Object)"%playerhead%", (Object)"{player.icon}").put((Object)"%gametime12%", (Object)"{world.time.format_12}").put((Object)"%gametime%", (Object)"{world.time.format_24}").put((Object)"%day%", (Object)"{world.day}").put((Object)"%weather%", (Object)"{world.weather.name}").put((Object)"%replayframe%", (Object)"{replaymod.frames.current}").put((Object)"%replaytotal%", (Object)"{replaymod.frames.total}").put((Object)"%replaytime%", (Object)"{replaymod.time.current}").put((Object)"%replaytimeleft%", (Object)"{replaymod.time.remaining}").put((Object)"%serverip%", (Object)"{server.address.short}").put((Object)"%servername%", (Object)"{server.name}").put((Object)"%players%", (Object)"{server.players.current}").put((Object)"%playersexcl%", (Object)"{server.players.current - 1}").put((Object)"%maxplayers%", (Object)"{server.players.max}").put((Object)"%motd%", (Object)"{server.motd.raw}").put((Object)"%servericon%", (Object)"{server.icon}").put((Object)"%realmname%", (Object)"{server.name}").put((Object)"%realmdescription%", (Object)"{server.motd.raw}").put((Object)"%realmgame%", (Object)"{server.minigame}").put((Object)"%realmicon%", (Object)"{server.icon}").build();
    private final Map<String, String> placeholderMappingsV2 = new HashMapBuilder().put((Object)"{{game.version}}", (Object)"{general.version}").put((Object)"{{game.mods}}", (Object)"{general.mods}").put((Object)"{{player.name}}", (Object)"{player.name}").put((Object)"{{player.uuid}}", (Object)"{player.uuid.full}").put((Object)"{{world.name}}", (Object)"{dimension.name}").put((Object)"{{world.difficulty}}", (Object)"{world.difficulty}").put((Object)"{{world.savename}}", (Object)"{world.name}").put((Object)"{{world.time.12}}", (Object)"{world.time.format_12}").put((Object)"{{world.time.24}}", (Object)"{world.time.format_24}").put((Object)"{{world.time.day}}", (Object)"{world.day}").put((Object)"{{world.weather}}", (Object)"{world.weather.name}").put((Object)"{{world.biome}}", (Object)"{biome.name}").put((Object)"{{player.position}}", (Object)"{'x: ' + player.position.x + ', y: ' + player.position.y + ', z: ' + player.position.z}").put((Object)"{{player.health.current}}", (Object)"{player.health.current}").put((Object)"{{player.health.max}}", (Object)"{player.health.max}").put((Object)"{{player.health.percent}}", (Object)"{(player.health.current / player.health.max) * 100}").put((Object)"{{player.item.off_hand}}", (Object)"{item.off_hand.name}").put((Object)"{{player.item.main_hand}}", (Object)"{item.main_hand.name}").put((Object)"{{images.player}}", (Object)"https://skinatar.firstdark.dev/avatar/{getOrDefault(player.uuid.short, player.name)}").put((Object)"{{images.player.head}}", (Object)"https://skinatar.firstdark.dev/head/{getOrDefault(player.uuid.short, player.name)}").put((Object)"{{images.realm}}", (Object)"{server.icon}").put((Object)"{{images.server}}", (Object)"{server.icon}").put((Object)"{{server.ip}}", (Object)"{server.address.short}").put((Object)"{{server.ip_underscore}}", (Object)"{replace(server.address.short, '.', '_')}").put((Object)"{{server.name}}", (Object)"{server.name}").put((Object)"{{server.motd}}", (Object)"{server.motd.raw}").put((Object)"{{server.players.count}}", (Object)"{server.players.current}").put((Object)"{{server.players.countexcl}}", (Object)"{server.players.current - 1}").put((Object)"{{server.players.max}}", (Object)"{server.players.max}").put((Object)"{{realm.name}}", (Object)"{server.name}").put((Object)"{{realm.description}}", (Object)"{server.motd.raw}").put((Object)"{{realm.world}}", (Object)"{server.type}").put((Object)"{{realm.game}}", (Object)"{server.minigame}").put((Object)"{{realm.players.count}}", (Object)"{server.players.count}").put((Object)"{{realm.players.max}}", (Object)"{server.players.max}").put((Object)"{{replaymod.time.elapsed}}", (Object)"{replaymod.time.current}").put((Object)"{{replaymod.time.left}}", (Object)"{replaymod.time.remaining}").put((Object)"{{replaymod.frames.current}}", (Object)"{replaymod.frames.current}").put((Object)"{{replaymod.frames.total}}", (Object)"{replaymod.frames.total}").put((Object)"{{launcher.name}}", (Object)"{general.brand}").put((Object)"{{launcher.pack}}", (Object)"{pack.name}").put((Object)"{{launcher.icon}}", (Object)"{pack.icon}").build();
    private int configVersion = -1;
    private int serverEntryVersion = -1;
    private int replayModVersion = -1;

    public HypherConverter(Map.Entry<Integer, String> entry) {
        this.fileVersion = entry.getKey();
        this.configPath = HypherConverter.jvmdowngrader$concat$$init$$1(entry.getValue());
        this.serverEntriesPath = HypherConverter.jvmdowngrader$concat$$init$$2(entry.getValue());
        this.replayModPath = HypherConverter.jvmdowngrader$concat$$init$$3(entry.getValue());
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        File replayModFile;
        Object dimensionList;
        Constants.LOG.info("Simple RPC (By: HypherionSA) config data found, attempting to migrate settings to CraftPresence...", new Object[0]);
        Constants.LOG.info("Note: If CraftPresence fails to load after this point, please verify your SimpleRPC config settings or file a ticket.", new Object[0]);
        try (FileConfig conf = FileConfig.of(this.configPath);){
            AbstractConfig genericEvent;
            AbstractConfig multiPlayerEvent;
            AbstractConfig singlePlayerEvent;
            AbstractConfig realmsEvent;
            AbstractConfig mainMenuEvent;
            AbstractConfig initEvent;
            AbstractConfig pauseEvent;
            AbstractConfig joinGameEvent;
            AbstractConfig serverListEvent;
            boolean areCustomsEnabled;
            Object entryObj2;
            boolean launcherIntegration;
            conf.load();
            this.configVersion = conf.getOrElse("general.version", Integer.valueOf(-1));
            Constants.LOG.debugInfo("Main Config file found (Version: %d, File Version: %d), interpreting data...", new Object[]{this.configVersion, this.fileVersion});
            if (!MathUtils.isWithinValue((double)this.configVersion, (double)13.0, (double)26.0, (boolean)true, (boolean)true)) {
                Constants.LOG.error("You are using an unsupported Simple RPC config file (Supported Versions: v%d - v%d, Found Version: v%d), skipping...", new Object[]{13, 26, this.configVersion});
                Config config = instance;
                return config;
            }
            if (MathUtils.isWithinValue((double)this.configVersion, (double)18.0, (double)24.0, (boolean)false, (boolean)false)) {
                Constants.LOG.error("You are using a Simple RPC config file from an unsupported mod release, please update your config using a newer mod version and try again...", new Object[0]);
                Config config = instance;
                return config;
            }
            Object clientId = this.getProperty(conf, "general.applicationID", "general.clientID");
            if (clientId != null) {
                instance.generalSettings.clientId = clientId.toString();
            }
            instance.advancedSettings.debugMode = (Boolean)conf.get("general.debugging");
            instance.generalSettings.detectATLauncherInstance = launcherIntegration = ((Boolean)conf.get("general.launcherIntegration")).booleanValue();
            instance.generalSettings.detectCurseManifest = launcherIntegration;
            instance.generalSettings.detectMCUpdaterInstance = launcherIntegration;
            instance.generalSettings.detectTechnicPack = launcherIntegration;
            instance.generalSettings.detectMultiMCManifest = launcherIntegration;
            boolean areOverridesEnabled = (Boolean)conf.get("dimension_overrides.enabled");
            dimensionList = conf.get("dimension_overrides.dimensions");
            if (dimensionList instanceof List) {
                List dimensions = (List)dimensionList;
                for (Object entryObj2 : dimensions) {
                    AbstractConfig target;
                    if (!(entryObj2 instanceof AbstractConfig)) continue;
                    AbstractConfig entry = (AbstractConfig)entryObj2;
                    String name = entry.get("name").toString();
                    boolean isBiome = name.startsWith("biome:");
                    if (isBiome) {
                        name = name.replaceFirst("biome:", "");
                    }
                    if ((target = this.getPresenceEntry(entry)) == null) continue;
                    ModuleData data = new ModuleData().setData(this.convertPresenceData(target, areOverridesEnabled, true));
                    (isBiome ? instance.biomeSettings.biomeData : instance.dimensionSettings.dimensionData).put(name, data);
                }
            }
            if ((areCustomsEnabled = ((Boolean)conf.get("custom.enabled")).booleanValue()) && (entryObj2 = conf.get("custom.variables")) instanceof List) {
                List customVars = (List)entryObj2;
                for (Object entryObj3 : customVars) {
                    if (!(entryObj3 instanceof AbstractConfig)) continue;
                    AbstractConfig entry = (AbstractConfig)entryObj3;
                    String name = entry.get("name").toString();
                    String value = entry.get("value").toString();
                    instance.displaySettings.dynamicVariables.put(name, this.processPlaceholder(value));
                }
            }
            instance.advancedSettings.enablePerGui = true;
            AbstractConfig realmsListEvent = this.getPresenceEntry((AbstractConfig)conf.get("realms_list"));
            if (realmsListEvent != null) {
                instance.advancedSettings.guiSettings.guiData.put("RealmsScreen", new ModuleData().setData(this.convertPresenceData(realmsListEvent)));
            }
            if ((serverListEvent = this.getPresenceEntry((AbstractConfig)conf.get("server_list"))) != null) {
                instance.advancedSettings.guiSettings.guiData.put("JoinMultiplayerScreen", new ModuleData().setData(this.convertPresenceData(serverListEvent)));
                instance.advancedSettings.guiSettings.guiData.put("DisconnectedScreen", new ModuleData().setData(this.convertPresenceData(serverListEvent)));
            }
            if ((joinGameEvent = this.getPresenceEntry((AbstractConfig)conf.get("join_game"))) != null) {
                instance.advancedSettings.guiSettings.guiData.put("LevelLoadingScreen", new ModuleData().setData(this.convertPresenceData(joinGameEvent)));
                instance.advancedSettings.guiSettings.guiData.put("ReceivingLevelScreen", new ModuleData().setData(this.convertPresenceData(joinGameEvent)));
            }
            if (this.isActive(ConfigFlag.USE_PAUSE_EVENT) && (pauseEvent = this.getPresenceEntry((AbstractConfig)conf.get("paused"))) != null) {
                instance.advancedSettings.guiSettings.guiData.put("PauseScreen", new ModuleData().setData(this.convertPresenceData(pauseEvent)));
            }
            if ((initEvent = this.getPresenceEntry((AbstractConfig)conf.get("init"))) != null) {
                instance.statusMessages.loadingData.setData(this.convertPresenceData(initEvent));
            }
            if ((mainMenuEvent = this.getPresenceEntry((AbstractConfig)conf.get("main_menu"))) != null) {
                instance.statusMessages.mainMenuData.setData(this.convertPresenceData(mainMenuEvent));
            }
            if ((realmsEvent = this.getPresenceEntry((AbstractConfig)conf.get("realms"))) != null) {
                instance.statusMessages.realmData.setData(this.convertPresenceData(realmsEvent));
            }
            if ((singlePlayerEvent = this.getPresenceEntry((AbstractConfig)conf.get("single_player"))) != null) {
                instance.statusMessages.singleplayerData.setData(this.convertPresenceData(singlePlayerEvent));
            }
            if ((multiPlayerEvent = this.getPresenceEntry((AbstractConfig)conf.get("multi_player"))) != null) {
                instance.serverSettings.serverData.get("default").setData(this.convertPresenceData(multiPlayerEvent));
            }
            if ((genericEvent = this.getPresenceEntry((AbstractConfig)conf.get("generic"))) != null) {
                instance.displaySettings.presenceData = this.convertPresenceData(genericEvent);
            }
            instance.save();
        }
        File serverEntriesFile = new File(this.serverEntriesPath);
        if (serverEntriesFile.exists()) {
            try (FileConfig conf = FileConfig.of(serverEntriesFile);){
                conf.load();
                this.serverEntryVersion = (Integer)conf.get("version");
                Constants.LOG.debugInfo("Server Entries file found (Version: %d, File Version: %d), interpreting data...", new Object[]{this.serverEntryVersion, this.fileVersion});
                boolean areOverridesEnabled = (Boolean)conf.get("enabled");
                dimensionList = conf.get("entry");
                if (dimensionList instanceof List) {
                    List entries = (List)dimensionList;
                    for (Object entryObj : entries) {
                        AbstractConfig entry;
                        AbstractConfig target;
                        if (!(entryObj instanceof AbstractConfig) || (target = this.getPresenceEntry(entry = (AbstractConfig)entryObj)) == null) continue;
                        instance.serverSettings.serverData.put((String)entry.get("ip"), new ModuleData().setData(this.convertPresenceData(target, areOverridesEnabled, true)));
                    }
                }
                instance.save();
            }
        }
        if ((replayModFile = new File(this.replayModPath)).exists()) {
            try (FileConfig conf = FileConfig.of(replayModFile);){
                AbstractConfig replayRenderEvent;
                AbstractConfig replayEditorEvent;
                conf.load();
                this.replayModVersion = (Integer)conf.get("general.version");
                Constants.LOG.debugInfo("Replay Mod Integration file found (Version: %d, File Version: %d), interpreting data...", new Object[]{this.replayModVersion, this.fileVersion});
                instance.advancedSettings.enablePerGui = true;
                AbstractConfig replayViewerEvent = this.getPresenceEntry((AbstractConfig)conf.get("replay_viewer"));
                if (replayViewerEvent != null) {
                    instance.advancedSettings.guiSettings.guiData.put("GuiReplayViewer", new ModuleData().setData(this.convertPresenceData(replayViewerEvent)));
                }
                if ((replayEditorEvent = this.getPresenceEntry((AbstractConfig)conf.get("replay_editor"))) != null) {
                    instance.advancedSettings.guiSettings.guiData.put("GuiReplayOverlay", new ModuleData().setData(this.convertPresenceData(replayEditorEvent)));
                }
                if ((replayRenderEvent = this.getPresenceEntry((AbstractConfig)conf.get("replay_render"))) != null) {
                    instance.advancedSettings.guiSettings.guiData.put("GuiVideoRenderer", new ModuleData().setData(this.convertPresenceData(replayRenderEvent)));
                }
                instance.save();
            }
        }
        Constants.LOG.info("Migration complete, thanks for using our mods! ~~ CDAGaming and HypherionSA", new Object[0]);
        return instance;
    }

    private String processPlaceholder(String original, boolean addMetadata) {
        String result = original;
        if (addMetadata) {
            result = HypherConverter.jvmdowngrader$concat$processPlaceholder$1(original);
        }
        if (!StringUtils.isNullOrEmpty((String)result)) {
            for (Map.Entry<String, String> entry : (this.isActive(ConfigFlag.USE_MULTI_RPC) ? this.placeholderMappingsV2 : this.placeholderMappings).entrySet()) {
                result = result.replace(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private String processPlaceholder(String original) {
        return this.processPlaceholder(original, false);
    }

    private ActivityType processActivityType(String original) {
        ActivityType activityType;
        if (StringUtils.isNullOrEmpty((String)original)) {
            return ActivityType.Playing;
        }
        switch (original.toLowerCase()) {
            case "streaming": {
                activityType = ActivityType.Streaming;
                break;
            }
            case "listening": {
                activityType = ActivityType.Listening;
                break;
            }
            case "watching": {
                activityType = ActivityType.Watching;
                break;
            }
            case "custom": {
                activityType = ActivityType.Custom;
                break;
            }
            case "competing": {
                activityType = ActivityType.Competing;
                break;
            }
            default: {
                activityType = ActivityType.Playing;
            }
        }
        return activityType;
    }

    private PresenceData convertPresenceData(AbstractConfig entry, boolean isEnabled, boolean useAsMain) {
        PresenceData data = new PresenceData();
        data.enabled = isEnabled;
        data.useAsMain = useAsMain;
        if (this.isActive(ConfigFlag.USE_MULTI_RPC)) {
            data.activityType = this.processActivityType((String)entry.get("type")).ordinal();
        }
        data.details = this.processPlaceholder((String)entry.get("description"));
        data.gameState = this.processPlaceholder((String)entry.get("state"));
        if (this.isActive(ConfigFlag.USE_IMAGE_POOLS)) {
            data.largeImageKey = this.tryCombineData(entry.get("largeImageKey"));
            data.smallImageKey = this.tryCombineData(entry.get("smallImageKey"));
        } else {
            data.largeImageKey = this.processPlaceholder((String)entry.get("largeImageKey"));
            data.smallImageKey = this.processPlaceholder((String)entry.get("smallImageKey"));
        }
        data.largeImageText = this.processPlaceholder((String)entry.get("largeImageText"));
        data.smallImageText = this.processPlaceholder((String)entry.get("smallImageText"));
        data.startTimestamp = "{data.general.time}";
        int buttonIndex = 1;
        Object t = entry.get("buttons");
        if (t instanceof List) {
            List buttons = (List)t;
            for (Object buttonEntryObj : buttons) {
                if (!(buttonEntryObj instanceof AbstractConfig)) continue;
                AbstractConfig buttonEntry = (AbstractConfig)buttonEntryObj;
                Button buttonData = new Button(this.processPlaceholder((String)buttonEntry.get("label")), this.processPlaceholder((String)buttonEntry.get("url")));
                data.addButton(HypherConverter.jvmdowngrader$concat$convertPresenceData$1(buttonIndex), buttonData);
                ++buttonIndex;
            }
        }
        return data;
    }

    private String tryCombineData(Object data) {
        Object object = data;
        int n = 0;
        switch (HypherConverter.jvmdowngrader$switch$tryCombineData$0(object, n)) {
            case -1: {
                return "";
            }
            case 0: {
                String item = (String)object;
                return this.combineData(item);
            }
        }
        try {
            return this.combineData((List)data);
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private String combineData(String item) {
        return this.processPlaceholder(item);
    }

    private String combineData(List<String> items) {
        StringBuilder dataBuilder = new StringBuilder();
        if (!items.isEmpty()) {
            if (items.size() > 1) {
                dataBuilder.append("{randomString(");
                for (int i = 0; i < items.size(); ++i) {
                    String output = this.processPlaceholder(items.get(i), true);
                    boolean hasExpr = EXPR_PATTERN.matcher(output).find();
                    dataBuilder.append(hasExpr ? "getResult(" : "").append(output).append(hasExpr ? ")" : "");
                    if (i >= items.size() - 1) continue;
                    dataBuilder.append(",");
                }
                dataBuilder.append(")}");
            } else {
                dataBuilder.append(this.processPlaceholder(J_U_List.getFirst(items)));
            }
        }
        return dataBuilder.toString();
    }

    private PresenceData convertPresenceData(AbstractConfig entry, boolean useAsMain) {
        return this.convertPresenceData(entry, entry.getOrElse("enabled", Boolean.valueOf(true)), useAsMain);
    }

    private PresenceData convertPresenceData(AbstractConfig entry) {
        return this.convertPresenceData(entry, true);
    }

    private AbstractConfig getPresenceEntry(AbstractConfig entry) {
        AbstractConfig target = null;
        if (this.isActive(ConfigFlag.USE_MULTI_RPC)) {
            List presences;
            Object e;
            Object presenceList = entry.get("presence");
            if (presenceList instanceof List && (e = J_U_List.getFirst(presences = (List)presenceList)) instanceof AbstractConfig) {
                AbstractConfig presenceEntry;
                target = presenceEntry = (AbstractConfig)e;
            }
        } else {
            target = entry;
        }
        return target;
    }

    private boolean isActive(ConfigFlag flag) {
        return !(this.configVersion >= 0 && this.configVersion < flag.jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$get$configVersion() || this.serverEntryVersion >= 0 && this.serverEntryVersion < flag.jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$get$serverEntryVersion() || this.replayModVersion >= 0 && this.replayModVersion < flag.jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$get$replayModVersion());
    }

    private Object getProperty(UnmodifiableConfig instance, String ... terms) {
        for (String term : terms) {
            if (!instance.contains(term)) continue;
            return instance.get(term);
        }
        return null;
    }

    private static int jvmdowngrader$switch$tryCombineData$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 1) {
            throw new IndexOutOfBoundsException(HypherConverter.jvmdowngrader$concat$jvmdowngrader$switch$tryCombineData$0$1(n, 1));
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof String) {
                        n2 = 0;
                        break;
                    }
                }
                default: {
                    n2 = 1;
                }
            }
        }
        return n2;
    }

    private static String jvmdowngrader$concat$$init$$1(String string) {
        return string + "simple-rpc.toml";
    }

    private static String jvmdowngrader$concat$$init$$2(String string) {
        return string + "server-entries.toml";
    }

    private static String jvmdowngrader$concat$$init$$3(String string) {
        return string + "simple-rpc-replaymod.toml";
    }

    private static String jvmdowngrader$concat$processPlaceholder$1(String string) {
        return "'" + string + "'";
    }

    private static String jvmdowngrader$concat$convertPresenceData$1(int n) {
        return "button_" + n;
    }

    private static String jvmdowngrader$concat$jvmdowngrader$switch$tryCombineData$0$1(int n, int n2) {
        return "Index " + n + " out of bounds for length " + n2;
    }

    @NestHost(value=HypherConverter.class)
    private static enum ConfigFlag {
        USE_IMAGE_POOLS(17, 2, 1),
        USE_MULTI_RPC(24, 3, 1),
        USE_PAUSE_EVENT(25, 3, 1);

        private final int configVersion;
        private final int serverEntryVersion;
        private final int replayModVersion;

        private ConfigFlag(int configVersion, int serverEntryVersion, int replayModVersion) {
            this.configVersion = configVersion;
            this.serverEntryVersion = serverEntryVersion;
            this.replayModVersion = replayModVersion;
        }

        public String toString() {
            return ConfigFlag.jvmdowngrader$concat$toString$1(StringUtils.getOrDefault((String)this.name(), (String)"N/A"), this.configVersion, this.serverEntryVersion, this.replayModVersion);
        }

        public int jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$get$configVersion() {
            return this.configVersion;
        }

        public void jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$set$configVersion(int n) {
            this.configVersion = n;
        }

        public int jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$get$serverEntryVersion() {
            return this.serverEntryVersion;
        }

        public void jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$set$serverEntryVersion(int n) {
            this.serverEntryVersion = n;
        }

        public int jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$get$replayModVersion() {
            return this.replayModVersion;
        }

        public void jvmdowngrader$nest$com_gitlab_cdagaming_craftpresence_core_config_migration_HypherConverter$ConfigFlag$set$replayModVersion(int n) {
            this.replayModVersion = n;
        }

        private static String jvmdowngrader$concat$toString$1(String string, int n, int n2, int n3) {
            return "ConfigFlag[key=" + string + "; configVersion=" + n + "; serverEntryVersion=" + n2 + "; replayModVersion=" + n3 + "]";
        }
    }
}

