/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.MappingUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import unilib.external.io.github.classgraph.ClassInfo;

public class GuiUtils
implements ExtendedModule {
    public final Map<String, ClassInfo> GUI_CLASSES = StringUtils.newHashMap();
    public List<String> GUI_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    public class_437 CURRENT_SCREEN;
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private String CURRENT_GUI_NAME;

    @Override
    public void clearFieldData() {
        this.DEFAULT_NAMES.clear();
        this.GUI_NAMES.clear();
        this.GUI_CLASSES.clear();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        CraftPresence.CLIENT.removeArguments("screen", "data.screen");
        CraftPresence.CLIENT.clearForcedData("screen");
        this.hasInitialized = false;
    }

    @Override
    public void updateData() {
        class_437 newScreen = GameUtils.getCurrentScreen((class_310)CraftPresence.instance);
        if (newScreen == null) {
            this.clearClientData();
        } else {
            String newScreenName = StringUtils.getOrDefault((String)MappingUtils.getClassName((Object)newScreen), (String)MappingUtils.getClassName(class_437.class));
            if (!newScreen.equals(this.CURRENT_SCREEN) || !newScreenName.equals(this.CURRENT_GUI_NAME)) {
                this.CURRENT_SCREEN = newScreen;
                this.CURRENT_GUI_NAME = newScreenName;
                if (!this.DEFAULT_NAMES.contains(newScreenName)) {
                    this.DEFAULT_NAMES.add(newScreenName);
                }
                if (!this.GUI_NAMES.contains(newScreenName)) {
                    this.GUI_NAMES.add(newScreenName);
                }
                if (!this.hasInitialized) {
                    this.initPresence();
                    this.hasInitialized = true;
                }
                this.updatePresence();
            }
        }
    }

    @Override
    public void getInternalData() {
        List searchClasses = StringUtils.newArrayList((Object[])new Class[]{class_437.class, class_465.class});
        for (ClassInfo classObj : FileUtils.getClassNamesMatchingSuperType((List)searchClasses, (String[])new String[0]).values()) {
            String screenName = MappingUtils.getClassName((ClassInfo)classObj);
            if (!this.DEFAULT_NAMES.contains(screenName)) {
                this.DEFAULT_NAMES.add(screenName);
            }
            if (!this.GUI_NAMES.contains(screenName)) {
                this.GUI_NAMES.add(screenName);
            }
            if (this.GUI_CLASSES.containsKey(screenName)) continue;
            this.GUI_CLASSES.put(screenName, classObj);
        }
    }

    @Override
    public void getConfigData() {
        for (String guiEntry : CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)guiEntry) || this.GUI_NAMES.contains(guiEntry)) continue;
            this.GUI_NAMES.add(guiEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean canFetchInternals() {
        return MappingUtils.areMappingsLoaded() && FileUtils.isClassGraphEnabled() && FileUtils.canScanClasses();
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.advancedSettings.enablePerGui : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return GameUtils.getCurrentScreen((class_310)CraftPresence.instance) != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    @Override
    public void initPresence() {
        this.syncArgument("screen.default.icon", () -> CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        this.syncArgument("data.screen.instance", () -> this.CURRENT_SCREEN, true);
        this.syncArgument("screen.name", () -> this.CURRENT_GUI_NAME, true);
        this.syncArgument("screen.message", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_GUI_NAME);
            String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
            return Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        });
        this.syncArgument("screen.icon", () -> {
            ModuleData defaultData = this.getDefaultData();
            ModuleData currentData = this.getData(this.CURRENT_GUI_NAME);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_GUI_NAME;
            String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
            return this.getResult(CraftPresence.CLIENT.imageOf(true, currentIcon, CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon), this.CURRENT_GUI_NAME);
        });
        CraftPresence.CLIENT.addForcedData("screen", () -> this.isInUse() ? this.getPresenceData(this.CURRENT_GUI_NAME) : null);
        CraftPresence.CLIENT.syncTimestamp("data.screen.time");
    }

    @Override
    public void updatePresence() {
    }
}

