/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.element;

import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import java.io.Serializable;
import java.util.Objects;

public class ModuleData
extends Module
implements Serializable {
    private static final long serialVersionUID = -5846802181463006850L;
    private static final ModuleData DEFAULT = new ModuleData();
    private String textOverride;
    private String iconOverride;
    private PresenceData data;

    public ModuleData(String textOverride, String iconOverride, PresenceData data) {
        this.setTextOverride(textOverride);
        this.setIconOverride(iconOverride);
        this.setData(data);
    }

    public ModuleData(ModuleData other) {
        this(other.textOverride, other.iconOverride, other.data);
    }

    public ModuleData(String textOverride, String iconOverride) {
        this(textOverride, iconOverride, null);
    }

    public ModuleData() {
        this(null, null);
    }

    @Override
    public ModuleData getDefaults() {
        return new ModuleData(DEFAULT);
    }

    @Override
    public ModuleData copy() {
        return new ModuleData(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof ModuleData) {
            ModuleData module = (ModuleData)target;
            if (!this.equals(target)) {
                this.setTextOverride(module.getTextOverride());
                this.setIconOverride(module.getIconOverride());
                this.setData(module.getData());
            }
        }
    }

    public String getTextOverride() {
        return this.textOverride;
    }

    public ModuleData setTextOverride(String textOverride) {
        this.textOverride = textOverride;
        return this;
    }

    public String getIconOverride() {
        return this.iconOverride;
    }

    public ModuleData setIconOverride(String iconOverride) {
        this.iconOverride = iconOverride;
        return this;
    }

    public PresenceData getData() {
        return this.data != null ? new PresenceData(this.data) : null;
    }

    public ModuleData setData(PresenceData data) {
        if (data != null) {
            this.data = new PresenceData(data);
        }
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return switch (name) {
            case "textOverride" -> this.textOverride;
            case "iconOverride" -> this.iconOverride;
            case "data" -> this.data;
            default -> null;
        };
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            switch (name) {
                case "textOverride": {
                    this.textOverride = (String)value;
                    break;
                }
                case "iconOverride": {
                    this.iconOverride = (String)value;
                    break;
                }
                case "data": {
                    this.data = (PresenceData)value;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModuleData)) {
            return false;
        }
        ModuleData other = (ModuleData)obj;
        return Objects.equals(other.textOverride, this.textOverride) && Objects.equals(other.iconOverride, this.iconOverride) && Objects.equals(other.data, this.data);
    }

    public int hashCode() {
        return Objects.hash(this.textOverride, this.iconOverride, this.data);
    }
}

