/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.DiscordUtils;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import com.gitlab.cdagaming.craftpresence.utils.server.ServerUtils;
import com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import com.gitlab.cdagaming.craftpresence.utils.world.DimensionUtils;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.UniLib;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.utils.ModUpdaterUtils;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.ScheduleUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_320;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class CraftPresence {
    public static final DiscordUtils CLIENT = new DiscordUtils();
    public static final ServerUtils SERVER = new ServerUtils();
    public static final BiomeUtils BIOMES = new BiomeUtils();
    public static final DimensionUtils DIMENSIONS = new DimensionUtils();
    public static final EntityUtils ENTITIES = new EntityUtils();
    public static final TileEntityUtils TILE_ENTITIES = new TileEntityUtils();
    public static final GuiUtils GUIS = new GuiUtils();
    public static final ModUpdaterUtils UPDATER = new ModUpdaterUtils("craftpresence", "https://raw.githubusercontent.com/CDAGaming/VersionLibrary/master/CraftPresence/update.json", "v2.6.1", ModUtils.MCVersion);
    public static class_310 instance;
    public static final ScheduleUtils SCHEDULER;
    public static class_320 session;
    public static class_1657 player;
    public static class_1937 world;
    public static String username;
    public static String uuid;
    public static Config CONFIG;
    public static boolean isDataLoaded;
    private static boolean initialized;
    private final Runnable initCallback;

    public CraftPresence(Runnable callback) {
        UniLib.assertLoaded();
        this.initCallback = callback;
        this.scheduleTick();
    }

    public CraftPresence() {
        this(null);
    }

    private void init() {
        UPDATER.checkForUpdates();
        CONFIG = Config.loadOrCreate(config -> config.applyEvents(instance -> CommandUtils.reloadData(true), CommandUtils::applyData).setGameVersion(ModUtils.MCProtocolID), CommandUtils::preInit);
        CommandUtils.init();
        Constants.LOG.debugWarn(Constants.TRANSLATOR.translate("craftpresence.logger.warning.debug_mode", new Object[0]), new Object[0]);
        Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.os", new Object[]{OSUtils.OS_NAME, OSUtils.OS_ARCH, OSUtils.IS_64_BIT}), new Object[0]);
        if (this.initCallback != null) {
            this.initCallback.run();
        }
        isDataLoaded = true;
        CLIENT.setup();
        CommandUtils.syncPlaceholders();
        CommandUtils.setupRPC();
        initialized = true;
    }

    private void scheduleTick() {
        CoreUtils.scheduleTickEvent((String)"CraftPresence", this::clientTick);
    }

    private void clientTick() {
        if (!CoreUtils.IS_CLOSING) {
            instance = ModUtils.getMinecraft();
            if (initialized || instance != null) {
                session = GameUtils.getSession((class_310)instance);
                if (initialized) {
                    player = WorldUtils.getPlayer((class_310)instance);
                    world = WorldUtils.getWorld((class_1297)player);
                    username = GameUtils.getUsername((class_310)instance);
                    uuid = GameUtils.getUuid((class_310)instance);
                    CommandUtils.reloadData(false);
                } else if (session != null) {
                    this.init();
                }
            }
        }
    }

    static {
        SCHEDULER = new ScheduleUtils(CommandUtils::onTick);
        isDataLoaded = false;
        initialized = false;
    }
}

