/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.core.file;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Function;

public final class FileWatcher {
    private static final long SLEEP_TIME_NANOS = 1000L;
    private static volatile FileWatcher DEFAULT_INSTANCE;
    private final Map<Path, WatchedDir> watchedDirs = new ConcurrentHashMap<Path, WatchedDir>();
    private final Map<Path, WatchedFile> watchedFiles = new ConcurrentHashMap<Path, WatchedFile>();
    private final Thread thread = new WatcherThread();
    private final Consumer<Exception> exceptionHandler;
    private volatile boolean run = true;

    public static synchronized FileWatcher defaultInstance() {
        if (DEFAULT_INSTANCE == null || !FileWatcher.DEFAULT_INSTANCE.run) {
            DEFAULT_INSTANCE = new FileWatcher();
        }
        return DEFAULT_INSTANCE;
    }

    public FileWatcher() {
        this((Consumer<Exception>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, printStackTrace(), (Ljava/lang/Exception;)V)());
    }

    public FileWatcher(Consumer<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.thread.start();
    }

    public void addWatch(File file, Runnable changeHandler) throws IOException {
        this.addWatch(file.toPath(), changeHandler);
    }

    public void addWatch(Path file, Runnable changeHandler) throws IOException {
        file = file.toAbsolutePath();
        Path dir = file.getParent();
        WatchedDir watchedDir = this.watchedDirs.computeIfAbsent(dir, (Function<Path, WatchedDir>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addWatch$0(java.nio.file.Path java.nio.file.Path ), (Ljava/nio/file/Path;)Lme/hypherionmc/moonconfig/core/file/FileWatcher$WatchedDir;)((Path)dir));
        WatchKey watchKey = dir.register(watchedDir.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watchedFiles.computeIfAbsent(file, (Function<Path, WatchedFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addWatch$1(me.hypherionmc.moonconfig.core.file.FileWatcher$WatchedDir java.nio.file.WatchKey java.lang.Runnable java.nio.file.Path ), (Ljava/nio/file/Path;)Lme/hypherionmc/moonconfig/core/file/FileWatcher$WatchedFile;)((WatchedDir)watchedDir, (WatchKey)watchKey, (Runnable)changeHandler));
    }

    public void setWatch(File file, Runnable changeHandler) throws IOException {
        this.setWatch(file.toPath(), changeHandler);
    }

    public void setWatch(Path file, Runnable changeHandler) throws IOException {
        WatchedFile watchedFile = this.watchedFiles.get(file = file.toAbsolutePath());
        if (watchedFile == null) {
            this.addWatch(file, changeHandler);
        } else {
            watchedFile.changeHandler = changeHandler;
        }
    }

    public void removeWatch(File file) {
        this.removeWatch(file.toPath());
    }

    public void removeWatch(Path file) {
        WatchedFile watchedFile;
        file = file.toAbsolutePath();
        Path dir = file.getParent();
        WatchedDir watchedDir = this.watchedDirs.get(dir);
        int remainingChildCount = watchedDir.watchedFileCount.decrementAndGet();
        if (remainingChildCount == 0) {
            this.watchedDirs.remove(dir);
        }
        if ((watchedFile = this.watchedFiles.remove(file)) != null) {
            watchedFile.watchKey.cancel();
        }
    }

    public void stop() throws IOException {
        this.run = false;
    }

    private static /* synthetic */ WatchedFile lambda$addWatch$1(WatchedDir watchedDir, WatchKey watchKey, Runnable changeHandler, Path k) {
        return new WatchedFile(watchedDir, watchKey, changeHandler);
    }

    private static /* synthetic */ WatchedDir lambda$addWatch$0(Path dir, Path k) {
        return new WatchedDir(dir);
    }

    private static final class WatchedFile {
        final WatchKey watchKey;
        volatile Runnable changeHandler;

        private WatchedFile(WatchedDir watchedDir, WatchKey watchKey, Runnable changeHandler) {
            this.watchKey = watchKey;
            this.changeHandler = changeHandler;
            watchedDir.watchedFileCount.getAndIncrement();
        }
    }

    private static final class WatchedDir {
        final Path dir;
        final WatchService watchService;
        final AtomicInteger watchedFileCount = new AtomicInteger();

        private WatchedDir(Path dir) {
            this.dir = dir;
            try {
                this.watchService = dir.getFileSystem().newWatchService();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class WatcherThread
    extends Thread {
        private WatcherThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (FileWatcher.this.run) {
                boolean allNull = true;
                Iterator it = FileWatcher.this.watchedDirs.values().iterator();
                block9: while (it.hasNext() && FileWatcher.this.run) {
                    WatchedDir watchedDir = (WatchedDir)it.next();
                    WatchKey key = null;
                    try {
                        key = watchedDir.watchService.poll(25L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (key == null) continue;
                    allNull = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!FileWatcher.this.run) break block9;
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        Path childPath = (Path)event.context();
                        Path filePath = watchedDir.dir.resolve(childPath);
                        WatchedFile watchedFile = (WatchedFile)FileWatcher.this.watchedFiles.get(filePath);
                        if (watchedFile == null) continue;
                        try {
                            watchedFile.changeHandler.run();
                        }
                        catch (Exception e) {
                            FileWatcher.this.exceptionHandler.accept(e);
                        }
                    }
                    key.reset();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!allNull) continue;
                LockSupport.parkNanos(1000L);
            }
            for (WatchedDir watchedDir : FileWatcher.this.watchedDirs.values()) {
                try {
                    watchedDir.watchService.close();
                }
                catch (IOException e) {
                    FileWatcher.this.exceptionHandler.accept(e);
                }
            }
            FileWatcher.this.watchedDirs.clear();
            FileWatcher.this.watchedFiles.clear();
        }
    }
}

