/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.moonconfig.core.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import me.hypherionmc.moonconfig.core.UnmodifiableConfig;
import me.hypherionmc.moonconfig.core.io.CharsWrapper;
import me.hypherionmc.moonconfig.core.io.ConfigWriter;
import me.hypherionmc.moonconfig.core.io.WritingException;
import me.hypherionmc.moonconfig.core.io.WritingMode;

public static class ConfigWriter$jvmdg$StaticDefaults {
    public static void write(ConfigWriter this_, UnmodifiableConfig config, OutputStream output, Charset charset) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, charset));
        this_.write(config, writer);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new WritingException("Failed to flush the writer", e);
        }
    }

    public static void write(ConfigWriter this_, UnmodifiableConfig config, OutputStream output) {
        this_.write(config, output, StandardCharsets.UTF_8);
    }

    public static void write(ConfigWriter this_, UnmodifiableConfig config, Path file, WritingMode writingMode) {
        this_.write(config, file, writingMode, StandardCharsets.UTF_8);
    }

    public static void write(ConfigWriter this_, UnmodifiableConfig config, Path file, WritingMode writingMode, Charset charset) {
        OpenOption[] options = writingMode == WritingMode.APPEND ? new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND} : new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        try (OutputStream output = Files.newOutputStream(file, options);){
            this_.write(config, output, charset);
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    public static void write(ConfigWriter this_, UnmodifiableConfig config, File file, WritingMode writingMode) {
        this_.write(config, file, writingMode, StandardCharsets.UTF_8);
    }

    public static void write(ConfigWriter this_, UnmodifiableConfig config, File file, WritingMode writingMode, Charset charset) {
        this_.write(config, file.toPath(), writingMode, charset);
    }

    public static void write(ConfigWriter this_, UnmodifiableConfig config, URL url) {
        URLConnection connection;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new WritingException("Unable to connect to the URL", e);
        }
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (OutputStream output = connection.getOutputStream();){
            this_.write(config, output, charset);
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    public static String writeToString(ConfigWriter this_, UnmodifiableConfig config) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(64);
        this_.write(config, builder);
        return builder.toString();
    }
}

