/*
 * Decompiled with CFR 0.152.
 */
package com.example.antimace;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiMacePlugin
extends JavaPlugin
implements Listener {
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("AntiMace plugin has been enabled!");
        if (this.config.getBoolean("disable-mace-crafting", true)) {
            this.getLogger().info("Mace crafting has been disabled!");
        } else {
            this.getLogger().info("Mace crafting is currently enabled in config.");
        }
    }

    public void onDisable() {
        this.getLogger().info("AntiMace plugin has been disabled!");
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (!this.config.getBoolean("disable-mace-crafting", true)) {
            return;
        }
        ItemStack result = event.getInventory().getResult();
        if (result != null && result.getType() == Material.MACE) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!this.config.getBoolean("disable-mace-crafting", true)) {
            return;
        }
        ItemStack result = event.getCurrentItem();
        if (result != null && result.getType() == Material.MACE) {
            event.setCancelled(true);
            if (event.getWhoClicked() != null) {
                this.getLogger().info("Prevented mace crafting by player: " + event.getWhoClicked().getName());
            } else {
                this.getLogger().info("Prevented automated mace crafting (likely autocrafter or similar)");
            }
        }
    }

    @EventHandler
    public void onCrafterCraft(CrafterCraftEvent event) {
        if (!this.config.getBoolean("disable-mace-crafting", true)) {
            return;
        }
        CraftingRecipe recipe = event.getRecipe();
        ItemStack result = recipe.getResult();
        if (result != null && result.getType() == Material.MACE) {
            event.setCancelled(true);
            this.getLogger().info("Prevented mace crafting by vanilla Crafter block at: " + event.getBlock().getLocation().toString());
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        if (!this.config.getBoolean("disable-mace-crafting", true)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.MACE && this.config.getBoolean("plugin.debug", false)) {
            this.getLogger().info("Detected mace item movement - monitoring for potential autocrafter bypass");
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("antimace")) {
            if (!sender.hasPermission("antimace.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "AntiMace v" + this.getDescription().getVersion());
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Mace crafting disabled: " + this.config.getBoolean("disable-mace-crafting", true));
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use '/antimace reload' to reload the configuration.");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.reloadPluginConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "AntiMace configuration reloaded!");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use '/antimace reload' or '/antimace' for info.");
            return true;
        }
        return false;
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.getLogger().info("AntiMace configuration reloaded!");
    }
}

