/*
 * Decompiled with CFR 0.152.
 */
package xyz.reknown.fastercrystals.api;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import xyz.reknown.fastercrystals.FasterCrystals;

public class FasterCrystalsAPI {
    private static FasterCrystalsAPI instance;
    private final FasterCrystals plugin;
    private final NamespacedKey fastCrystalsKey;

    private FasterCrystalsAPI(FasterCrystals plugin) {
        this.plugin = plugin;
        this.fastCrystalsKey = new NamespacedKey((Plugin)plugin, "fastcrystals");
    }

    public static void init(FasterCrystals plugin) {
        if (instance != null) {
            throw new IllegalStateException("FasterCrystalsAPI is already initialized.");
        }
        instance = new FasterCrystalsAPI(plugin);
    }

    public static FasterCrystalsAPI getInstance() {
        if (instance == null) {
            throw new IllegalStateException("FasterCrystalsAPI has not been initialized yet.");
        }
        return instance;
    }

    public void setFastCrystals(Player player, boolean enabled) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        pdc.set(this.fastCrystalsKey, PersistentDataType.BYTE, (Object)((byte)(enabled ? 1 : 0)));
    }

    public boolean isFastCrystalsEnabled(Player player) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        return (Byte)pdc.getOrDefault(this.fastCrystalsKey, PersistentDataType.BYTE, (Object)1) == 1;
    }

    public void toggleFastCrystals(Player player) {
        boolean newState = !this.isFastCrystalsEnabled(player);
        this.setFastCrystals(player, newState);
    }
}

