/*
 * Decompiled with CFR 0.152.
 */
package xyz.reknown.fastercrystals.listeners.packet;

import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import xyz.reknown.fastercrystals.FasterCrystals;
import xyz.reknown.fastercrystals.enums.AnimPackets;
import xyz.reknown.fastercrystals.user.User;

public class AnimationListener
extends SimplePacketListenerAbstract {
    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.ANIMATION) {
            return;
        }
        FasterCrystals plugin = (FasterCrystals)JavaPlugin.getPlugin(FasterCrystals.class);
        Player player = (Player)event.getPlayer();
        if (player == null) {
            return;
        }
        User user = plugin.getUsers().get(player);
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (player.hasPotionEffect(PotionEffectType.WEAKNESS)) {
            return;
        }
        if (user == null || !user.isFasterCrystals()) {
            return;
        }
        AnimPackets lastPacket = user.getLastPacket();
        Location eyeLoc = player.getEyeLocation();
        Vector direction = eyeLoc.getDirection();
        FoliaScheduler.getRegionScheduler().run((Plugin)plugin, eyeLoc, task -> {
            RayTraceResult bResult;
            if (lastPacket == AnimPackets.IGNORE) {
                return;
            }
            if (user.isIgnoreAnim()) {
                return;
            }
            Location newEyeLoc = player.getEyeLocation();
            if (eyeLoc.getWorld() != newEyeLoc.getWorld() || newEyeLoc.distanceSquared(eyeLoc) > 100.0) {
                return;
            }
            RayTraceResult result = eyeLoc.getWorld().rayTraceEntities(eyeLoc, direction, player.getAttribute(Attribute.PLAYER_ENTITY_INTERACTION_RANGE).getValue(), 0.0, entity -> {
                if (!((CraftEntity)entity).getHandle().isPickable()) {
                    return false;
                }
                if (entity.getType() != EntityType.PLAYER) {
                    return true;
                }
                Player p = (Player)entity;
                if (p.getGameMode() == GameMode.SPECTATOR) {
                    return false;
                }
                return !player.getUniqueId().equals(p.getUniqueId()) && player.canSee(p);
            });
            if (result == null) {
                return;
            }
            Entity entity2 = result.getHitEntity();
            if (entity2 == null || entity2.getType() != EntityType.END_CRYSTAL) {
                return;
            }
            if (entity2.getTicksLived() == 0) {
                return;
            }
            if (!entity2.getBoundingBox().contains(eyeLoc.toVector()) && (bResult = eyeLoc.getWorld().rayTraceBlocks(eyeLoc, direction, player.getGameMode() == GameMode.CREATIVE ? 5.0 : 4.5)) != null) {
                Block block = bResult.getHitBlock();
                Vector eyeLocV = eyeLoc.toVector();
                if (block != null) {
                    if (eyeLocV.distanceSquared(bResult.getHitPosition()) <= eyeLocV.distanceSquared(result.getHitPosition())) {
                        return;
                    }
                    if (lastPacket != AnimPackets.START_DIGGING && lastPacket != AnimPackets.ATTACK) {
                        return;
                    }
                }
            }
            player.attack(entity2);
        });
    }
}

