/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.network.stepcrafter;

import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.ultramega.stepcrafter.common.network.stepcrafter.StepCraftingNetworkComponent;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterProvider;
import com.ultramega.stepcrafter.common.stepcrafter.StepCraftingParentContainer;
import com.ultramega.stepcrafter.common.support.PatternMinMax;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class StepCraftingNetworkComponentImpl
implements StepCraftingNetworkComponent,
StepCraftingParentContainer {
    private final Set<PatternMinMax> patterns = new HashSet<PatternMinMax>();
    private final Map<ResourceKey, PriorityQueue<PatternHolder>> patternsByOutput = new HashMap<ResourceKey, PriorityQueue<PatternHolder>>();
    private final Set<ResourceMinMaxAmount> outputs = new HashSet<ResourceMinMaxAmount>();

    public void onContainerAdded(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof StepCrafterProvider) {
            StepCrafterProvider provider = (StepCrafterProvider)networkNode;
            provider.onAddedIntoContainer(this);
        }
    }

    public void onContainerRemoved(NetworkNodeContainer container) {
        NetworkNode networkNode = container.getNode();
        if (networkNode instanceof StepCrafterProvider) {
            StepCrafterProvider provider = (StepCrafterProvider)networkNode;
            provider.onRemovedFromContainer(this);
        }
    }

    @Override
    public Set<ResourceMinMaxAmount> getOutputs() {
        return this.outputs;
    }

    @Override
    public void add(StepCrafterProvider provider, PatternMinMax pattern) {
        boolean priority = false;
        this.patterns.add(pattern);
        pattern.pattern().layout().outputs().forEach(output -> this.outputs.add(new ResourceMinMaxAmount(output.resource(), pattern.minAmount(), pattern.maxAmount(), 1L, false)));
        for (ResourceAmount output2 : pattern.pattern().layout().outputs()) {
            this.patternsByOutput.computeIfAbsent(output2.resource(), k -> new PriorityQueue<PatternHolder>(Comparator.comparingInt(PatternHolder::priority).reversed())).add(new PatternHolder(pattern, 0));
        }
    }

    @Override
    public void remove(StepCrafterProvider provider, PatternMinMax pattern) {
        this.patterns.remove(pattern);
        for (ResourceAmount output : pattern.pattern().layout().outputs()) {
            boolean noOtherPatternHasThisOutput;
            PriorityQueue<PatternHolder> holders = this.patternsByOutput.get(output.resource());
            if (holders == null) continue;
            holders.removeIf(holder -> holder.pattern.equals(pattern));
            if (holders.isEmpty()) {
                this.patternsByOutput.remove(output.resource());
            }
            if (!(noOtherPatternHasThisOutput = this.patterns.stream().noneMatch(otherPattern -> otherPattern.pattern().layout().outputs().stream().anyMatch(o -> o.resource().equals((Object)output.resource())) && otherPattern.minAmount() == pattern.minAmount() && otherPattern.maxAmount() == pattern.maxAmount() && otherPattern.batchSize() == pattern.batchSize()))) continue;
            this.outputs.removeIf(r -> r.resource().equals((Object)output.resource()) && r.minAmount() == pattern.minAmount() && r.maxAmount() == pattern.maxAmount() && r.batchSize() == pattern.batchSize());
        }
    }

    private record PatternHolder(PatternMinMax pattern, int priority) {
    }
}

