/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepcrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.stepcrafter.common.ContentNames;
import com.ultramega.stepcrafter.common.Platform;
import com.ultramega.stepcrafter.common.UpgradeDestinations;
import com.ultramega.stepcrafter.common.registry.BlockEntities;
import com.ultramega.stepcrafter.common.registry.Items;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterContainerMenu;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterData;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterNetworkNode;
import com.ultramega.stepcrafter.common.support.PatternMinMax;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerData;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class StepCrafterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<StepCrafterNetworkNode>
implements ExtendedMenuProvider<StepCrafterData>,
BlockEntityWithDrops,
PatternInventory.Listener {
    static final int UPGRADES = 8;
    static final int PATTERNS = 45;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_PATTERNS = "patterns";
    private final PatternResourceContainerImpl patternResourceContainer = StepCrafterBlockEntity.createPatternResourcesContainer(() -> ((StepCrafterBlockEntity)this).getLevel(), this::getAmountSlotUpgrades);
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(8, (UpgradeDestination)UpgradeDestinations.STEP_CRAFTER, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.getConfig().getStepCrafter().getEnergyUsage();
        long patternEnergyUsage = this.patternResourceContainer.getEnergyUsage();
        ((StepCrafterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
        this.speed = Math.clamp((long)c.getAmount((UpgradeItem)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade()) * (long)Platform.getConfig().getStepCrafter().getSpeedMultiplier(), 0, Integer.MAX_VALUE);
        this.amountSlotUpgrades = c.getAmount((UpgradeItem)Items.INSTANCE.getSlotUpgrade());
        this.setChanged();
    });
    private int speed = 0;
    private int amountSlotUpgrades = 0;

    public StepCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getStepCrafter(), pos, state, (AbstractNetworkNode)new StepCrafterNetworkNode(Platform.getConfig().getStepCrafter().getEnergyUsage(), 45));
        this.patternResourceContainer.addListener(container -> {
            long upgradeEnergyUsage = this.upgradeContainer.getEnergyUsage();
            long baseEnergyUsage = Platform.getConfig().getStepCrafter().getEnergyUsage();
            long patternEnergyUsage = this.patternResourceContainer.getEnergyUsage();
            ((StepCrafterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + patternEnergyUsage + upgradeEnergyUsage);
            this.setChanged();
        });
        this.patternResourceContainer.setListener(this);
        this.patternResourceContainer.setChangedListener(this::onPatternResourcesChange);
        ((StepCrafterNetworkNode)this.mainNetworkNode).setBlockEntity(this);
    }

    static PatternResourceContainerImpl createPatternResourcesContainer(Supplier<@NullableType Level> levelSupplier, Supplier<Integer> amountSupplier) {
        return new PatternResourceContainerImpl(45, levelSupplier, null, null, false, amountSupplier);
    }

    static PatternResourceContainerImpl createPatternResourcesContainer(StepCrafterData data, Supplier<@NullableType Level> levelSupplier, Supplier<Integer> amountSupplier) {
        PatternResourceContainerImpl exportedResourcesContainer = StepCrafterBlockEntity.createPatternResourcesContainer(levelSupplier, amountSupplier);
        PatternResourceContainerData resourceContainerData = data.patternResources();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            resourceContainerData.resources().get(i).ifPresent(resource -> exportedResourcesContainer.set(ii, (ResourceMinMaxAmount)resource));
        }
        return exportedResourcesContainer;
    }

    PatternResourceContainerImpl getPatternResourceContainer() {
        return this.patternResourceContainer;
    }

    UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getAmountSlotUpgrades() {
        return this.amountSlotUpgrades;
    }

    public Component getName() {
        Component customName = this.getCustomName();
        if (customName != null) {
            return customName;
        }
        return ContentNames.STEP_CRAFTER;
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new StepCrafterContainerMenu(syncId, inventory, this);
    }

    public StepCrafterData getMenuData() {
        return new StepCrafterData(new AutocrafterData(false, true, false), PatternResourceContainerData.of(this.patternResourceContainer));
    }

    public StreamEncoder<RegistryFriendlyByteBuf, StepCrafterData> getMenuCodec() {
        return StepCrafterData.STREAM_CODEC;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_PATTERNS, (Tag)this.patternResourceContainer.createTag(provider));
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_PATTERNS)) {
            this.patternResourceContainer.fromTag(tag.getList(TAG_PATTERNS, 10), provider);
        }
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        drops.addAll((Collection)this.upgradeContainer.getDrops());
        for (int i = 0; i < this.patternResourceContainer.getContainerSize(); ++i) {
            drops.add((Object)this.patternResourceContainer.getItem(i));
        }
        return drops;
    }

    void setCustomName(String name) {
        this.setCustomName((Component)(name.trim().isBlank() ? null : Component.literal((String)name)));
        this.setChanged();
    }

    private void onPatternResourcesChange(int index) {
        this.setChanged();
        this.patternChanged(index);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide()) {
            return;
        }
        for (int i = 0; i < this.patternResourceContainer.getContainerSize(); ++i) {
            this.patternChanged(i);
        }
    }

    public void patternChanged(int slot) {
        if (this.level == null) {
            return;
        }
        Pattern pattern = RefinedStorageApi.INSTANCE.getPattern(this.patternResourceContainer.getItem(slot), this.level).orElse(null);
        ResourceMinMaxAmount resource = this.patternResourceContainer.get(slot);
        ((StepCrafterNetworkNode)this.mainNetworkNode).setPattern(slot, pattern != null && resource != null ? new PatternMinMax(pattern, resource.minAmount(), resource.maxAmount(), resource.batchSize()) : null);
    }
}

