/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepcrafter;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterBlockEntity;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterProvider;
import com.ultramega.stepcrafter.common.stepcrafter.StepCraftingParentContainer;
import com.ultramega.stepcrafter.common.support.PatternMinMax;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class StepCrafterNetworkNode
extends SimpleNetworkNode
implements StepCrafterProvider {
    private final Actor actor = new NetworkNodeActor((NetworkNode)this);
    private final Set<StepCraftingParentContainer> parents = new HashSet<StepCraftingParentContainer>();
    private final PatternMinMax[] patterns;
    private StepCrafterBlockEntity blockEntity;

    public StepCrafterNetworkNode(long energyUsage, int patterns) {
        super(energyUsage);
        this.patterns = new PatternMinMax[patterns];
    }

    public void doWork() {
        super.doWork();
        if (this.network == null || !this.isActive()) {
            return;
        }
        StorageNetworkComponent storageComponent = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
        PatternResourceContainerImpl patternResources = this.blockEntity.getPatternResourceContainer();
        block0: for (int i = 0; i < patternResources.getContainerSize(); ++i) {
            ResourceMinMaxAmount resource = patternResources.get(i);
            PatternMinMax pattern = this.patterns[i];
            if (resource == null || pattern == null) continue;
            for (int j = 0; j < this.blockEntity.getSpeed() + 1; ++j) {
                ResourceKey resourceKey = ((ResourceAmount)pattern.pattern().layout().outputs().getFirst()).resource();
                long stored = storageComponent.get(resourceKey);
                boolean crafting = resource.isCrafting();
                if (!crafting && stored >= resource.minAmount()) continue block0;
                if (crafting && stored >= resource.maxAmount()) {
                    patternResources.set(i, resource.toBuilder().isCrafting(false).build());
                    continue block0;
                }
                if (!this.craftOneItemNew(storageComponent, pattern.pattern())) {
                    if (!crafting) continue block0;
                    patternResources.set(i, resource.toBuilder().isCrafting(false).build());
                    continue block0;
                }
                if (crafting) continue;
                patternResources.set(i, resource.toBuilder().isCrafting(true).build());
            }
        }
    }

    private boolean craftOneItemNew(StorageNetworkComponent storageComponent, Pattern pattern) {
        for (Ingredient ingredient : pattern.layout().ingredients()) {
            if (ingredient.amount() != 1L) {
                return false;
            }
            for (ResourceKey resource : ingredient.inputs()) {
                if (storageComponent.extract(resource, 1L, Action.SIMULATE, this.actor) == 1L) continue;
                return false;
            }
        }
        for (ResourceAmount resource : pattern.layout().outputs()) {
            if (storageComponent.insert(resource.resource(), resource.amount(), Action.SIMULATE, this.actor) == resource.amount()) continue;
            return false;
        }
        for (ResourceAmount resource : pattern.layout().byproducts()) {
            if (storageComponent.insert(resource.resource(), resource.amount(), Action.SIMULATE, this.actor) == resource.amount()) continue;
            return false;
        }
        for (Ingredient ingredient : pattern.layout().ingredients()) {
            for (ResourceKey resource : ingredient.inputs()) {
                storageComponent.extract(resource, 1L, Action.EXECUTE, this.actor);
            }
        }
        for (ResourceAmount resource : pattern.layout().outputs()) {
            storageComponent.insert(resource.resource(), resource.amount(), Action.EXECUTE, this.actor);
        }
        for (ResourceAmount resource : pattern.layout().byproducts()) {
            storageComponent.insert(resource.resource(), resource.amount(), Action.EXECUTE, this.actor);
        }
        return true;
    }

    public void setBlockEntity(StepCrafterBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public void setPattern(int index, @Nullable PatternMinMax pattern) {
        PatternMinMax oldPattern = this.patterns[index];
        if (oldPattern != null) {
            this.parents.forEach(parent -> parent.remove(this, oldPattern));
        }
        this.patterns[index] = pattern;
        if (pattern != null) {
            this.parents.forEach(parent -> parent.add(this, pattern));
        }
    }

    protected void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        if (!newActive) {
            for (PatternMinMax pattern : this.patterns) {
                if (pattern == null) continue;
                this.parents.forEach(parent -> parent.remove(this, pattern));
            }
            return;
        }
        for (PatternMinMax pattern : this.patterns) {
            if (pattern == null) continue;
            this.parents.forEach(parent -> parent.add(this, pattern));
        }
    }

    @Override
    public void onAddedIntoContainer(StepCraftingParentContainer parentContainer) {
        this.parents.add(parentContainer);
        for (PatternMinMax pattern : this.patterns) {
            if (pattern == null) continue;
            parentContainer.add(this, pattern);
        }
    }

    @Override
    public void onRemovedFromContainer(StepCraftingParentContainer parentContainer) {
        this.parents.remove(parentContainer);
        for (PatternMinMax pattern : this.patterns) {
            if (pattern == null) continue;
            parentContainer.remove(this, pattern);
        }
    }
}

