/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepcrafter;

import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterContainerMenu;
import com.ultramega.stepcrafter.common.support.AbstractAdvancedBaseScreen;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class StepCrafterScreen
extends AbstractAdvancedBaseScreen<StepCrafterContainerMenu>
implements StepCrafterContainerMenu.Listener,
PatternOutputRenderingScreen {
    private static final Component EDIT = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.edit_name");
    private static final ResourceLocation NAME_BACKGROUND = IdentifierUtil.createIdentifier((String)"widget/autocrafter_name");
    private static final List<String> CRAFTER_NAME_HISTORY = new ArrayList<String>();
    @Nullable
    private EditBox nameField;
    @Nullable
    private Button editButton;
    private boolean editName;

    public StepCrafterScreen(StepCrafterContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, new TextMarquee(title, StepCrafterScreen.getTitleMaxWidth()));
    }

    protected void init() {
        super.init();
        ((StepCrafterContainerMenu)this.getMenu()).setListener(this);
        this.addSideButton((AbstractSideButtonWidget)new RedstoneModeSideButtonWidget(((StepCrafterContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        if (this.nameField == null) {
            this.nameField = new SearchFieldWidget(this.font, this.leftPos + 8 + 1, this.topPos + 6 + 1, 153, new History(CRAFTER_NAME_HISTORY));
            this.nameField.setValue(this.title.getString());
            this.nameField.setBordered(false);
            this.nameField.setCanLoseFocus(false);
            this.addWidget((GuiEventListener)this.nameField);
        }
        if (this.editButton == null) {
            this.editButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)EDIT, button -> this.setEditName(true)).pos(this.getEditButtonX(), this.topPos + this.titleLabelY - 3).size(StepCrafterScreen.getEditButtonWidth(), 14).build());
            this.setEditName(false);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.nameField != null && this.editName) {
            this.nameField.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderSlotMinMax(graphics, false);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.editName) {
            graphics.blitSprite(NAME_BACKGROUND, this.leftPos + 7, this.topPos + 5, 162, 12);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.editName) {
            this.renderPlayerInventoryTitle(graphics);
            return;
        }
        super.renderLabels(graphics, mouseX, mouseY);
    }

    private void setEditName(boolean editName) {
        this.editName = editName;
        if (this.nameField != null) {
            this.nameField.visible = editName;
            this.nameField.setFocused(editName);
            this.nameField.setCanLoseFocus(!editName);
            if (editName) {
                this.setFocused((GuiEventListener)this.nameField);
            } else {
                this.setFocused(null);
            }
        }
        if (this.editButton != null) {
            this.editButton.visible = !editName;
        }
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.nameField != null && this.editName && this.nameField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.nameField != null && this.editName) {
            if (this.nameField.keyPressed(key, scanCode, modifiers)) {
                return true;
            }
            if (this.nameField.isFocused() && this.saveOrCancel(key)) {
                return true;
            }
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        PatternResourceSlot resourceSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof PatternResourceSlot && (resourceSlot = (PatternResourceSlot)slot).isActive() && this.tryOpenResourceAmountScreen(resourceSlot, false, true)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    private boolean saveOrCancel(int key) {
        if (key == 257 || key == 335) {
            ((StepCrafterContainerMenu)this.getMenu()).changeName(Objects.requireNonNull(this.nameField).getValue());
            this.setEditName(false);
            return true;
        }
        if (key == 256) {
            this.setEditName(false);
            Objects.requireNonNull(this.nameField).setValue(this.titleMarquee.getText().getString());
            return true;
        }
        return false;
    }

    @Override
    public void nameChanged(Component name) {
        this.titleMarquee.setText(name);
        if (this.nameField != null) {
            this.nameField.setValue(name.getString());
        }
        if (this.editButton != null) {
            this.editButton.setX(this.getEditButtonX());
        }
    }

    public boolean canDisplayOutput(ItemStack stack) {
        return ((StepCrafterContainerMenu)this.getMenu()).containsPattern(stack);
    }

    private int getEditButtonX() {
        return this.leftPos + this.titleLabelX + this.titleMarquee.getEffectiveWidth(this.font) + 2;
    }

    private static int getTitleMaxWidth() {
        int editButtonWidth = StepCrafterScreen.getEditButtonWidth();
        return 162 - editButtonWidth - 10;
    }

    private static int getEditButtonWidth() {
        return Minecraft.getInstance().font.width((FormattedText)EDIT) + 8;
    }
}

