/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.ultramega.stepcrafter.common.support.PlayerInventorySlotMarker;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractPatternResourceContainerMenu
extends AbstractBaseContainerMenu {
    protected final Player player;
    private final List<PatternResourceSlot> patternResourceSlots = new ArrayList<PatternResourceSlot>();

    public AbstractPatternResourceContainerMenu(@Nullable MenuType<?> type, int syncId, Player player) {
        super(type, syncId);
        this.player = player;
    }

    private Optional<PatternResourceSlot> getPatternResourceSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.slots.size()) {
            return Optional.empty();
        }
        Object object = this.slots.get(slotIndex);
        if (object instanceof PatternResourceSlot) {
            PatternResourceSlot resourceSlot = (PatternResourceSlot)((Object)object);
            return Optional.of(resourceSlot);
        }
        return Optional.empty();
    }

    public List<PatternResourceSlot> getPatternResourceSlots() {
        return this.patternResourceSlots;
    }

    public void handlePatternResourceSlotUpdate(int slotIndex, @Nullable ResourceMinMaxAmount resourceAmount) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.change(resourceAmount));
    }

    public void handlePatternResourceFilterSlotUpdate(int slotIndex, PlatformResourceKey resource) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.setFilter(resource));
    }

    public void handlePatternResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.change(this.getCarried(), tryAlternatives));
    }

    public void handlePatternResourceSlotAmountChange(int slotIndex, long minAmount, long maxAmount, long batchSize) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.changeAmount(minAmount, maxAmount, batchSize));
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        for (PatternResourceSlot resourceSlot : this.patternResourceSlots) {
            resourceSlot.broadcastChanges(this.player);
        }
    }

    protected void addSlots(PatternResourceContainerImpl filterContainer, UpgradeContainer upgradeContainer) {
        for (int i = 0; i < upgradeContainer.getContainerSize(); ++i) {
            super.addSlot((Slot)new UpgradeSlot(upgradeContainer, i, 187 + i / 4 * 18, 6 + i % 4 * 18));
        }
        super.addPlayerInventory(this.player.getInventory(), 8, 55);
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)upgradeContainer);
    }

    public void amountSlotUpgradesChanged(int amountSlotUpgrades) {
        for (Slot slot : this.slots) {
            if (!(slot instanceof PlayerInventorySlotMarker)) continue;
            int y = 55 + amountSlotUpgrades * 18;
            if (slot.getContainerSlot() < 9) {
                Platform.INSTANCE.setSlotY(slot, y + 4 + 54);
                continue;
            }
            Platform.INSTANCE.setSlotY(slot, y + (slot.getContainerSlot() / 9 - 1) * 18);
        }
    }

    protected Slot addSlot(Slot slot) {
        if (slot instanceof PatternResourceSlot) {
            PatternResourceSlot resourceSlot = (PatternResourceSlot)slot;
            this.patternResourceSlots.add(resourceSlot);
        }
        return super.addSlot(slot);
    }

    protected void resetSlots() {
        super.resetSlots();
        this.patternResourceSlots.clear();
    }

    public void addToResourceSlotIfNotExisting(ItemStack stack) {
        for (PatternResourceSlot resourceSlot : this.patternResourceSlots) {
            if (!resourceSlot.contains(stack)) continue;
            return;
        }
        for (PatternResourceSlot resourceSlot : this.patternResourceSlots) {
            if (!resourceSlot.changeIfEmpty(stack)) continue;
            return;
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot instanceof PatternResourceSlot) {
            return true;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public abstract int getAmountSlotUpgrades();
}

