/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class MaintainableClientTooltipComponent
implements ClientTooltipComponent {
    private static final ResourceLocation ICON = StepCrafterIdentifierUtil.createStepCrafterIdentifier("grid/stock");
    private static final int ICON_SIZE = 8;
    private static final int ICON_MARGIN = 4;
    private static final BiFunction<Long, Long, Component> MAINTAINING = (minAmount, maxAmount) -> Component.translatable((String)"tooltip.stepcrafter.grid.maintaining", (Object[])new Object[]{minAmount, maxAmount});
    private static final Function<Long, Component> MAINTAINING_SINGLE = amount -> Component.translatable((String)"tooltip.stepcrafter.grid.maintaining_single", (Object[])new Object[]{amount});
    private final Component text;

    private MaintainableClientTooltipComponent(Component text) {
        this.text = text;
    }

    public static MaintainableClientTooltipComponent maintaining(long minAmount, long maxAmount) {
        return new MaintainableClientTooltipComponent(minAmount != maxAmount ? MAINTAINING.apply(minAmount, maxAmount) : MAINTAINING_SINGLE.apply(minAmount));
    }

    public int getHeight() {
        return 10;
    }

    public int getWidth(Font font) {
        return 12 + (int)((float)font.width((FormattedText)this.text) * 0.7f);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        int yOffset = SmallText.isSmall() ? 2 : 0;
        SmallText.render((Font)font, (FormattedCharSequence)this.text.getVisualOrderText(), (int)(x + 8 + 4), (int)(y + yOffset), (int)10452816, (Matrix4f)matrix, (MultiBufferSource.BufferSource)bufferSource, (float)0.7f);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.blitSprite(ICON, x, y, 8, 8);
    }
}

