/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support.patternresource;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceSlotAmountChangePacket;
import com.ultramega.stepcrafter.common.packet.s2c.PatternResourceSlotUpdatePacket;
import com.ultramega.stepcrafter.common.support.DisabledPatternResourceSlot;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternResourceSlot
extends ValidatedSlot {
    private final PatternResourceContainerImpl container;
    private final Component helpText;
    private final Level level;
    private final boolean isFilter;
    @Nullable
    private ResourceMinMaxAmount cachedResource;

    public PatternResourceSlot(PatternResourceContainerImpl container, int index, Component helpText, int x, int y, Level level, boolean isFilter) {
        super((Container)container, index, x, y, stack -> container.canPlaceItem(index, (ItemStack)stack));
        this.container = container;
        this.helpText = helpText;
        this.level = level;
        this.isFilter = isFilter;
        this.cachedResource = this.container.get(index);
    }

    public PatternResourceSlot forAmountScreen(int newX, int newY) {
        return new DisabledPatternResourceSlot(this.container, this.getContainerSlot(), this.helpText, newX, newY, this.level, this.isFilter);
    }

    public boolean isEmpty() {
        return this.container.isEmpty(this.getContainerSlot());
    }

    public void change(ItemStack stack, boolean tryAlternatives) {
        this.container.change(this.getContainerSlot(), stack, tryAlternatives);
    }

    public void change(@Nullable ResourceMinMaxAmount resourceAmount) {
        if (resourceAmount == null) {
            this.container.remove(this.getContainerSlot());
        } else {
            this.container.set(this.getContainerSlot(), resourceAmount);
        }
    }

    public void setFilter(PlatformResourceKey resource) {
        if (!this.isFilter) {
            return;
        }
        this.container.setNewResource(this.getContainerSlot(), (ResourceKey)resource);
    }

    public boolean changeIfEmpty(ItemStack stack) {
        if (!this.isEmpty()) {
            return false;
        }
        this.container.setNewResource(this.getContainerSlot(), (ResourceKey)ItemResource.ofItemStack((ItemStack)stack));
        return true;
    }

    public void changeAmount(long minAmount, long maxAmount, long batchSize) {
        this.container.setMinAmount(this.index, minAmount);
        this.container.setMaxAmount(this.index, maxAmount);
        this.container.setBatchSize(this.index, batchSize);
        this.container.changed(this.index);
    }

    public void changeAmountOnClient(double minAmount, double maxAmount, double batchSize) {
        PlatformResourceKey resource = this.getResource();
        if (resource == null) {
            return;
        }
        long normalizedMinAmount = resource.getResourceType().normalizeAmount(minAmount);
        long normalizedMaxAmount = resource.getResourceType().normalizeAmount(maxAmount);
        long normalizedBatchSize = resource.getResourceType().normalizeAmount(batchSize);
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new PatternResourceSlotAmountChangePacket(this.index, normalizedMinAmount, normalizedMaxAmount, normalizedBatchSize));
    }

    @Nullable
    public PlatformResourceKey getResource() {
        return this.container.getResource(this.getContainerSlot());
    }

    public long getMinAmount() {
        return this.container.getMinAmount(this.index);
    }

    public long getMaxAmount() {
        return this.container.getMaxAmount(this.index);
    }

    public long getBatchSize() {
        return this.container.getBatchSize(this.index);
    }

    public boolean isCrafting() {
        return this.container.isCrafting(this.index);
    }

    public boolean contains(ItemStack stack) {
        return ItemStack.matches((ItemStack)stack, (ItemStack)this.getItem());
    }

    public void broadcastChanges(Player player) {
        ResourceMinMaxAmount currentResourceAmount = this.container.get(this.getContainerSlot());
        if (!Objects.equals(currentResourceAmount, this.cachedResource)) {
            this.cachedResource = currentResourceAmount;
            this.broadcastChange((ServerPlayer)player, currentResourceAmount);
        }
    }

    private void broadcastChange(ServerPlayer player, @Nullable ResourceMinMaxAmount contents) {
        Platform.INSTANCE.sendPacketToClient(player, (CustomPacketPayload)new PatternResourceSlotUpdatePacket(this.index, Optional.ofNullable(contents)));
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public boolean isActive() {
        return this.container.isActive(this.index);
    }

    public boolean mayPickup(Player player) {
        return super.mayPickup(player) && !this.isFilter;
    }

    public boolean mayPlace(ItemStack stack) {
        return super.mayPlace(stack) && !this.isFilter;
    }

    @Nullable
    public ResourceFactory getPrimaryResourceFactory() {
        return this.container.getPrimaryResourceFactory();
    }

    @Nullable
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.container.getAlternativeResourceFactories();
    }

    public Component getHelpText() {
        return this.helpText;
    }
}

