/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.resourceconfiguration;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.support.amount.ActionButton;
import com.refinedmods.refinedstorage.common.support.amount.ActionIcon;
import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.mixin.ActionButtonInvoker;
import com.ultramega.stepcrafter.common.resourceconfiguration.ResourceConfigurationContainerMenu;
import com.ultramega.stepcrafter.common.support.AbstractAdvancedBaseScreen;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlotRendering;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.apache.commons.lang3.tuple.Triple;

public class ResourceConfigurationScreen
extends AbstractAdvancedBaseScreen<ResourceConfigurationContainerMenu>
implements PatternOutputRenderingScreen {
    private static final class_2960 TEXTURE_1 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/resource_configuration_1.png");
    private static final class_2960 TEXTURE_2 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/resource_configuration_2.png");
    private static final class_5250 TITLE = IdentifierUtil.createTranslation((String)"gui", (String)"configure_amount");
    private static final class_5250 SET_TEXT = IdentifierUtil.createTranslation((String)"gui", (String)"configure_amount.set");
    private static final int ACTION_BUTTON_HEIGHT = 20;
    private static final int ACTION_BUTTON_WIDTH = 58;
    @Nullable
    protected ActionButton confirmButton;
    @Nullable
    protected class_342 minAmountField;
    @Nullable
    protected class_342 maxAmountField;
    @Nullable
    protected class_342 batchSizeField;
    private final class_437 parent;
    private final PatternResourceSlot resourceSlot;
    private final AmountOperations<Double> amountOperations;
    private final double minInitialAmount;
    private final double maxInitialAmount;
    private final double batchSizeInitialAmount;
    private final boolean showBatchSize;
    private final double minAmount;
    private final double maxAmount;

    public ResourceConfigurationScreen(class_437 parent, class_1661 playerInventory, PatternResourceSlot resourceSlot, boolean showBatchSize) {
        super(new ResourceConfigurationContainerMenu(resourceSlot, 120 + (showBatchSize ? 25 : 0), 42), playerInventory, (class_2561)TITLE);
        this.parent = parent;
        this.resourceSlot = resourceSlot;
        this.amountOperations = DoubleAmountOperations.INSTANCE;
        this.minInitialAmount = resourceSlot.getMinAmount();
        this.maxInitialAmount = resourceSlot.getMaxAmount();
        this.batchSizeInitialAmount = resourceSlot.getBatchSize();
        this.showBatchSize = showBatchSize;
        this.minAmount = resourceSlot.getResource() != null ? resourceSlot.getResource().getResourceType().getDisplayAmount(0L) : 0.0;
        this.maxAmount = Double.MAX_VALUE;
        this.field_2792 = 179;
        this.field_2779 = 99;
    }

    protected void method_25426() {
        super.method_25426();
        this.addConfirmButton();
        this.addAmountFields();
    }

    protected void method_2385(class_332 graphics, class_1735 slot) {
    }

    protected void renderResourceSlots(class_332 graphics) {
        PatternResourceSlotRendering.render(graphics, ((ResourceConfigurationContainerMenu)this.method_17577()).getResourceSlot(), this.field_2776, this.field_2800);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51448().method_22909();
        int n = this.titleMarquee.getEffectiveWidth(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        boolean hoveringOverTitle = this.method_2378(this.field_25267, this.field_25268, n, 9, mouseX, mouseY);
        this.titleMarquee.render(graphics, this.field_2776 + this.field_25267, this.field_2800 + this.field_25268, this.field_22793, hoveringOverTitle);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        class_5250 minText = class_2561.method_43471((String)"gui.stepcrafter.resource_configuration.minimum");
        class_5250 maxText = class_2561.method_43471((String)"gui.stepcrafter.resource_configuration.maximum");
        class_5250 batchSizeText = class_2561.method_43471((String)"gui.stepcrafter.resource_configuration.batch_size");
        int biggestTextWidth = Math.max(this.field_22793.method_27525((class_5348)minText), this.field_22793.method_27525((class_5348)maxText));
        int width = 40;
        int y = 39;
        if (this.showBatchSize) {
            biggestTextWidth = Math.max(biggestTextWidth, this.field_22793.method_27525((class_5348)batchSizeText));
            width += 27;
            y -= 6;
        }
        int x = (width - biggestTextWidth) / 2;
        graphics.method_51439(this.field_22793, (class_2561)minText, x, y, 0x404040, false);
        graphics.method_51439(this.field_22793, (class_2561)maxText, x, y + 14, 0x404040, false);
        if (this.showBatchSize) {
            graphics.method_51439(this.field_22793, (class_2561)batchSizeText, x, y + 28, 0x404040, false);
        }
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        List<class_5684> tooltip;
        PatternResourceSlot patternSlot;
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof PatternResourceSlot && (patternSlot = (PatternResourceSlot)class_17352).getResource() != null && !(tooltip = this.getPatternResourceSlotTooltip((ResourceKey)patternSlot.getResource(), patternSlot)).isEmpty()) {
            Platform.INSTANCE.renderTooltip(graphics, tooltip, x, y);
            return;
        }
        super.method_2380(graphics, x, y);
    }

    @Override
    protected void addPatternResourceSlotTooltips(PatternResourceSlot slot, List<class_5684> tooltip) {
    }

    private void addAmountFields() {
        int x = this.field_2776 + 40 + (this.showBatchSize ? 25 : 0);
        int y = this.field_2800 + 39 - (this.showBatchSize ? 6 : 0);
        int width = 62;
        String minOriginalValue = this.minAmountField != null ? this.minAmountField.method_1882() : null;
        Objects.requireNonNull(this.field_22793);
        this.minAmountField = new class_342(this.field_22793, x, y, 62, 9, (class_2561)class_2561.method_43473());
        this.minAmountField.method_1858(false);
        this.minAmountField.method_1868(0xFFFFFF);
        if (minOriginalValue != null) {
            this.minAmountField.method_1852(minOriginalValue);
            this.onAmountFieldChanged(this.minAmountField, 0);
        }
        this.updateAmount(this.minAmountField, this.minInitialAmount);
        this.minAmountField.method_1862(true);
        this.minAmountField.method_1856(true);
        this.minAmountField.method_25365(true);
        this.minAmountField.method_1863(value -> {
            Triple<Optional<Double>, Optional<Double>, Optional<Double>> amounts;
            this.onAmountFieldChanged(this.minAmountField, 0);
            this.onAmountFieldChanged(this.maxAmountField, 1);
            if (this.maxAmountField != null && ((Optional)(amounts = this.getAndValidateAmount()).getLeft()).isPresent() && ((Optional)amounts.getMiddle()).isEmpty()) {
                this.maxAmountField.method_1852(this.minAmountField.method_1882());
            }
        });
        this.method_25395((class_364)this.minAmountField);
        this.method_37063((class_364)this.minAmountField);
        String maxOriginalValue = this.maxAmountField != null ? this.maxAmountField.method_1882() : null;
        Objects.requireNonNull(this.field_22793);
        this.maxAmountField = new class_342(this.field_22793, x, y + 14, 62, 9, (class_2561)class_2561.method_43473());
        this.maxAmountField.method_1858(false);
        this.maxAmountField.method_1868(0xFFFFFF);
        if (maxOriginalValue != null) {
            this.maxAmountField.method_1852(maxOriginalValue);
            this.onAmountFieldChanged(this.maxAmountField, 1);
        }
        this.updateAmount(this.maxAmountField, this.maxInitialAmount);
        this.maxAmountField.method_1862(true);
        this.maxAmountField.method_1856(true);
        this.maxAmountField.method_1863(value -> this.onAmountFieldChanged(this.maxAmountField, 1));
        this.method_37063((class_364)this.maxAmountField);
        if (!this.showBatchSize) {
            return;
        }
        String batchOriginalValue = this.batchSizeField != null ? this.batchSizeField.method_1882() : null;
        Objects.requireNonNull(this.field_22793);
        this.batchSizeField = new class_342(this.field_22793, x, y + 28, 62, 9, (class_2561)class_2561.method_43473());
        this.batchSizeField.method_1858(false);
        this.batchSizeField.method_1868(0xFFFFFF);
        if (batchOriginalValue != null) {
            this.batchSizeField.method_1852(batchOriginalValue);
            this.onAmountFieldChanged(this.batchSizeField, 2);
        }
        this.updateAmount(this.batchSizeField, this.batchSizeInitialAmount);
        this.batchSizeField.method_1862(true);
        this.batchSizeField.method_1856(true);
        this.batchSizeField.method_1863(value -> this.onAmountFieldChanged(this.batchSizeField, 2));
        this.method_37063((class_364)this.batchSizeField);
    }

    private void addConfirmButton() {
        ActionButton button = ActionButtonInvoker.create(this.field_2776 + 116, this.field_2800 + 74, 58, 20, (class_2561)SET_TEXT, btn -> this.tryConfirm(true));
        button.setIcon(this.getConfirmButtonIcon());
        this.confirmButton = (ActionButton)this.method_37063((class_364)button);
    }

    @Nullable
    protected ActionIcon getConfirmButtonIcon() {
        return ActionIcon.SET;
    }

    protected final void updateAmount(@Nullable class_342 amountField, Double amount) {
        if (amountField == null) {
            return;
        }
        amountField.method_1852(this.amountOperations.format((Number)amount));
    }

    protected void onAmountFieldChanged(@Nullable class_342 amountField, int type) {
        boolean thisValid;
        if (amountField == null) {
            return;
        }
        Triple<Optional<Double>, Optional<Double>, Optional<Double>> amounts = this.getAndValidateAmount();
        boolean valid = ((Optional)amounts.getLeft()).isPresent() && ((Optional)amounts.getMiddle()).isPresent() && ((Optional)amounts.getRight()).isPresent();
        switch (type) {
            case 0: {
                boolean bl = ((Optional)amounts.getLeft()).isPresent();
                break;
            }
            case 1: {
                boolean bl = ((Optional)amounts.getMiddle()).isPresent();
                break;
            }
            case 2: {
                boolean bl = ((Optional)amounts.getRight()).isPresent();
                break;
            }
            default: {
                boolean bl = thisValid = false;
            }
        }
        if (this.confirmButton != null) {
            this.confirmButton.field_22763 = valid;
            this.confirmButton.setIcon(valid ? this.getConfirmButtonIcon() : ActionIcon.ERROR);
        } else {
            this.tryConfirm(false);
        }
        amountField.method_1868(thisValid ? 0xFFFFFF : 0xFF5555);
    }

    protected final Triple<Optional<Double>, Optional<Double>, Optional<Double>> getAndValidateAmount() {
        Optional<Double> batchSize;
        if (this.minAmountField == null || this.maxAmountField == null) {
            return Triple.of(Optional.empty(), Optional.empty(), Optional.empty());
        }
        Optional min = this.amountOperations.parse(this.minAmountField.method_1882()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.minAmount, (Number)this.maxAmount));
        Optional<Object> max = this.amountOperations.parse(this.maxAmountField.method_1882()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.minAmount, (Number)this.maxAmount));
        Optional<Double> optional = batchSize = this.batchSizeField != null ? this.amountOperations.parse(this.batchSizeField.method_1882()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.minAmount, (Number)this.maxAmount)) : Optional.of(1.0);
        if (min.isPresent() && max.isPresent() && (Double)max.get() < (Double)min.get()) {
            max = Optional.empty();
        }
        return Triple.of(min, max, batchSize);
    }

    public boolean canDisplayOutput(class_1799 stack) {
        return true;
    }

    private void tryConfirm(boolean closeToParent) {
        Triple<Optional<Double>, Optional<Double>, Optional<Double>> amounts = this.getAndValidateAmount();
        if (((Optional)amounts.getLeft()).isPresent() && ((Optional)amounts.getMiddle()).isPresent() && ((Optional)amounts.getRight()).isPresent() && this.confirm((Double)((Optional)amounts.getLeft()).get(), (Double)((Optional)amounts.getMiddle()).get(), (Double)((Optional)amounts.getRight()).get()) && closeToParent) {
            this.tryCloseToParent();
        }
    }

    public void method_25419() {
        this.tryCloseToParent();
    }

    private void tryCloseToParent() {
        class_310.method_1551().method_1507(this.parent);
    }

    protected boolean confirm(Double newMinAmount, Double newMaxAmount, Double newBatchSize) {
        this.resourceSlot.changeAmountOnClient(newMinAmount, newMaxAmount, newBatchSize);
        return true;
    }

    @Override
    protected class_2960 getTexture() {
        return !this.showBatchSize ? TEXTURE_1 : TEXTURE_2;
    }
}

