/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.ItemResourceRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.resourceconfiguration.ResourceConfigurationScreen;
import com.ultramega.stepcrafter.common.support.AbstractPatternResourceContainerMenu;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public abstract class AbstractAdvancedBaseScreen<T extends class_1703>
extends AbstractBaseScreen<T> {
    private static final SmallTextClientTooltipComponent SHIFT_CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((class_2561)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.shift_click_to_clear"));
    private static final class_2561 SHIFT_CLICK_TO_CONFIGURE_AMOUNT = StepCrafterIdentifierUtil.createStepCrafterTranslationAsHeading("gui", "filter_slot.shift_click_to_configure_amount");
    private static final class_2561 CLICK_TO_CONFIGURE_AMOUNT = IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.click_to_configure_amount");
    private static final class_5684 EMPTY_FILTER = class_5684.method_32662((class_5481)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.empty_filter").method_30937());
    private static final class_5684 EMPTY_PATTERN_SLOT = class_5684.method_32662((class_5481)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"autocrafter.empty_pattern_slot").method_30937());
    private static final class_2960 TEXTURE_0 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_0.png");
    private static final class_2960 TEXTURE_1 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_1.png");
    private static final class_2960 TEXTURE_2 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_2.png");
    private static final class_2960 TEXTURE_3 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_3.png");
    private static final class_2960 TEXTURE_4 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_4.png");
    protected final class_1661 playerInventory;
    private int lastAmountSlotUpgrades = -1;

    public AbstractAdvancedBaseScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.playerInventory = playerInventory;
        this.field_2792 = 228;
        this.determineStuff();
    }

    protected AbstractAdvancedBaseScreen(T menu, class_1661 playerInventory, TextMarquee title) {
        super(menu, playerInventory, title);
        this.playerInventory = playerInventory;
        this.field_2792 = 228;
        this.determineStuff();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.determineStuff();
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    protected void renderSlotMinMax(class_332 graphics, boolean showBatchSize) {
        class_1703 class_17032 = this.method_17577();
        if (!(class_17032 instanceof AbstractPatternResourceContainerMenu)) {
            return;
        }
        AbstractPatternResourceContainerMenu patternContainerMenu = (AbstractPatternResourceContainerMenu)class_17032;
        class_4587 poseStack = graphics.method_51448();
        for (PatternResourceSlot slot : patternContainerMenu.getPatternResourceSlots()) {
            if (!slot.method_7682() || slot.getResource() == null) continue;
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(slot.getResource().getClass());
            String formattedMinAmount = rendering.formatAmount(slot.getMinAmount(), true);
            String formattedMaxAmount = rendering.formatAmount(slot.getMaxAmount(), true);
            poseStack.method_22903();
            poseStack.method_46416((float)(this.field_2776 + slot.field_7873), (float)(this.field_2800 + slot.field_7872), 260.0f);
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            graphics.method_25303(this.field_22793, formattedMinAmount, 0, 0, 0xFFFFFF);
            if (showBatchSize) {
                String formattedBatchSize = ItemResourceRendering.INSTANCE.formatAmount(slot.getBatchSize(), true);
                graphics.method_25303(this.field_22793, formattedBatchSize, 0, 12, 0xFFFFFF);
            }
            graphics.method_25303(this.field_22793, formattedMaxAmount, 0, 24, 0xFFFFFF);
            if (slot.isCrafting()) {
                graphics.method_52706(Sprites.AUTOCRAFTING_INDICATOR, 22, -2, 10, 10);
            }
            poseStack.method_22909();
        }
    }

    private void determineStuff() {
        int amountSlotUpgrades = 0;
        class_1703 class_17032 = this.method_17577();
        if (class_17032 instanceof AbstractPatternResourceContainerMenu) {
            AbstractPatternResourceContainerMenu patternContainerMenu = (AbstractPatternResourceContainerMenu)class_17032;
            amountSlotUpgrades = patternContainerMenu.getAmountSlotUpgrades();
        }
        if (this.lastAmountSlotUpgrades == amountSlotUpgrades) {
            return;
        }
        this.field_25270 = 42 + amountSlotUpgrades * 18;
        this.field_2779 = 137 + amountSlotUpgrades * 18;
        if (this.lastAmountSlotUpgrades != -1) {
            this.method_25426();
        }
        this.lastAmountSlotUpgrades = amountSlotUpgrades;
    }

    protected boolean tryOpenResourceAmountScreen(PatternResourceSlot slot, boolean showBatchSize, boolean hasToPressShift) {
        boolean canOpen;
        boolean isFilterSlot = slot.getResource() != null;
        boolean isNotTryingToRemoveFilter = hasToPressShift == AbstractAdvancedBaseScreen.method_25442();
        boolean isNotCarryingItem = this.method_17577().method_34255().method_7960();
        boolean bl = canOpen = isFilterSlot && isNotTryingToRemoveFilter && isNotCarryingItem;
        if (canOpen && this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ResourceConfigurationScreen((class_437)this, this.playerInventory, slot, showBatchSize));
        }
        return canOpen;
    }

    protected void method_2380(class_332 graphics, int x, int y) {
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof PatternResourceSlot) {
            PatternResourceSlot patternSlot = (PatternResourceSlot)class_17352;
            List<class_5684> tooltip = this.getPatternResourceSlotTooltip(this.field_2797.method_34255(), patternSlot);
            if (!tooltip.isEmpty()) {
                Platform.INSTANCE.renderTooltip(graphics, tooltip, x, y);
                return;
            }
        }
        super.method_2380(graphics, x, y);
    }

    public final List<class_5684> getPatternResourceSlotTooltip(class_1799 carried, PatternResourceSlot slot) {
        PlatformResourceKey resource = slot.getResource();
        if (resource == null) {
            return this.getTooltipForEmptyPatternResourceSlot(carried, slot);
        }
        return this.getPatternResourceSlotTooltip((ResourceKey)resource, slot);
    }

    protected List<class_5684> getPatternResourceSlotTooltip(ResourceKey resource, PatternResourceSlot slot) {
        List<class_5684> tooltip = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).getTooltip(resource).stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        this.addPatternResourceSlotTooltips(slot, tooltip);
        return tooltip;
    }

    private List<class_5684> getTooltipForEmptyPatternResourceSlot(class_1799 carried, PatternResourceSlot slot) {
        ArrayList<class_5684> tooltip = new ArrayList<class_5684>();
        tooltip.add(slot.isFilter() ? EMPTY_FILTER : EMPTY_PATTERN_SLOT);
        tooltip.addAll(this.getPatternResourceSlotHelpTooltip(carried, slot));
        tooltip.add(HelpClientTooltipComponent.create((class_2561)slot.getHelpText()));
        return tooltip;
    }

    private List<class_5684> getPatternResourceSlotHelpTooltip(class_1799 carried, PatternResourceSlot slot) {
        if (carried.method_7960() || slot.getPrimaryResourceFactory() == null || slot.getAlternativeResourceFactories() == null) {
            return Collections.emptyList();
        }
        ArrayList<class_5684> lines = new ArrayList<class_5684>();
        slot.getPrimaryResourceFactory().create(carried).ifPresent(primaryResourceInstance -> lines.add(MouseClientTooltipComponent.resource((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.LEFT, (ResourceKey)primaryResourceInstance.resource(), null)));
        for (ResourceFactory alternativeResourceFactory : slot.getAlternativeResourceFactories()) {
            Optional result = alternativeResourceFactory.create(carried);
            result.ifPresent(alternativeResourceInstance -> lines.add(MouseClientTooltipComponent.resource((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.RIGHT, (ResourceKey)alternativeResourceInstance.resource(), null)));
        }
        return lines;
    }

    protected void addPatternResourceSlotTooltips(PatternResourceSlot slot, List<class_5684> tooltip) {
        tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"tooltip.stepcrafter.resource_configuration.minimum_amount", (Object[])new Object[]{slot.getMinAmount()}).method_27692(class_124.field_1080).method_30937()));
        tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"tooltip.stepcrafter.resource_configuration.maximum_amount", (Object[])new Object[]{slot.getMaxAmount()}).method_27692(class_124.field_1080).method_30937()));
        if (slot.isFilter()) {
            tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43469((String)"tooltip.stepcrafter.resource_configuration.batch_size", (Object[])new Object[]{slot.getBatchSize()}).method_27692(class_124.field_1080).method_30937()));
        }
        tooltip.add((class_5684)new SmallTextClientTooltipComponent(slot.isFilter() ? CLICK_TO_CONFIGURE_AMOUNT : SHIFT_CLICK_TO_CONFIGURE_AMOUNT));
        if (slot.isFilter()) {
            tooltip.add((class_5684)SHIFT_CLICK_TO_CLEAR);
        }
    }

    protected class_2960 getTexture() {
        return switch (this.lastAmountSlotUpgrades) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            case 4 -> TEXTURE_4;
            default -> TEXTURE_0;
        };
    }
}

