/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.ultramega.stepcrafter.common.support.PlayerInventorySlotMarker;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;

public abstract class AbstractPatternResourceContainerMenu
extends AbstractBaseContainerMenu {
    protected final class_1657 player;
    private final List<PatternResourceSlot> patternResourceSlots = new ArrayList<PatternResourceSlot>();

    public AbstractPatternResourceContainerMenu(@Nullable class_3917<?> type, int syncId, class_1657 player) {
        super(type, syncId);
        this.player = player;
    }

    private Optional<PatternResourceSlot> getPatternResourceSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.field_7761.size()) {
            return Optional.empty();
        }
        Object object = this.field_7761.get(slotIndex);
        if (object instanceof PatternResourceSlot) {
            PatternResourceSlot resourceSlot = (PatternResourceSlot)((Object)object);
            return Optional.of(resourceSlot);
        }
        return Optional.empty();
    }

    public List<PatternResourceSlot> getPatternResourceSlots() {
        return this.patternResourceSlots;
    }

    public void handlePatternResourceSlotUpdate(int slotIndex, @Nullable ResourceMinMaxAmount resourceAmount) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.change(resourceAmount));
    }

    public void handlePatternResourceFilterSlotUpdate(int slotIndex, PlatformResourceKey resource) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.setFilter(resource));
    }

    public void handlePatternResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.change(this.method_34255(), tryAlternatives));
    }

    public void handlePatternResourceSlotAmountChange(int slotIndex, long minAmount, long maxAmount, long batchSize) {
        this.getPatternResourceSlot(slotIndex).ifPresent(slot -> slot.changeAmount(minAmount, maxAmount, batchSize));
    }

    public void method_7623() {
        super.method_7623();
        for (PatternResourceSlot resourceSlot : this.patternResourceSlots) {
            resourceSlot.broadcastChanges(this.player);
        }
    }

    protected void addSlots(PatternResourceContainerImpl filterContainer, UpgradeContainer upgradeContainer) {
        for (int i = 0; i < upgradeContainer.method_5439(); ++i) {
            super.method_7621((class_1735)new UpgradeSlot(upgradeContainer, i, 187 + i / 4 * 18, 6 + i % 4 * 18));
        }
        super.addPlayerInventory(this.player.method_31548(), 8, 55);
        this.transferManager.addBiTransfer((class_1263)this.player.method_31548(), (class_1263)upgradeContainer);
    }

    public void amountSlotUpgradesChanged(int amountSlotUpgrades) {
        for (class_1735 slot : this.field_7761) {
            if (!(slot instanceof PlayerInventorySlotMarker)) continue;
            int y = 55 + amountSlotUpgrades * 18;
            if (slot.method_34266() < 9) {
                Platform.INSTANCE.setSlotY(slot, y + 4 + 54);
                continue;
            }
            Platform.INSTANCE.setSlotY(slot, y + (slot.method_34266() / 9 - 1) * 18);
        }
    }

    protected class_1735 method_7621(class_1735 slot) {
        if (slot instanceof PatternResourceSlot) {
            PatternResourceSlot resourceSlot = (PatternResourceSlot)slot;
            this.patternResourceSlots.add(resourceSlot);
        }
        return super.method_7621(slot);
    }

    protected void resetSlots() {
        super.resetSlots();
        this.patternResourceSlots.clear();
    }

    public void addToResourceSlotIfNotExisting(class_1799 stack) {
        for (PatternResourceSlot resourceSlot : this.patternResourceSlots) {
            if (!resourceSlot.contains(stack)) continue;
            return;
        }
        for (PatternResourceSlot resourceSlot : this.patternResourceSlots) {
            if (!resourceSlot.changeIfEmpty(stack)) continue;
            return;
        }
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if (slot instanceof PatternResourceSlot) {
            return true;
        }
        return super.method_7613(stack, slot);
    }

    public abstract int getAmountSlotUpgrades();
}

