/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support.patternresource;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternResourceContainerImpl
extends PatternInventory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternResourceContainerImpl.class);
    private final ResourceMinMaxAmount[] slots;
    @Nullable
    private final ResourceFactory primaryResourceFactory;
    @Nullable
    private final Set<ResourceFactory> alternativeResourceFactories;
    private final boolean isFilter;
    private final Supplier<Integer> amountOfSlotUpgrades;
    @Nullable
    private Consumer<Integer> changedListener;

    public PatternResourceContainerImpl(int size, Supplier<@NullableType class_1937> levelSupplier, @Nullable ResourceFactory primaryResourceFactory, @Nullable Set<ResourceFactory> alternativeResourceFactories, boolean isFilter, Supplier<Integer> amountOfSlotUpgrades) {
        super(size, levelSupplier);
        this.slots = new ResourceMinMaxAmount[size];
        this.primaryResourceFactory = primaryResourceFactory;
        this.alternativeResourceFactories = alternativeResourceFactories;
        this.isFilter = isFilter;
        this.amountOfSlotUpgrades = amountOfSlotUpgrades;
    }

    public void setChangedListener(@Nullable Consumer<Integer> changedListener) {
        this.changedListener = changedListener;
    }

    public void change(int index, class_1799 stack, boolean tryAlternatives) {
        if (tryAlternatives && this.alternativeResourceFactories != null) {
            for (ResourceFactory resourceFactory : this.alternativeResourceFactories) {
                Optional result = resourceFactory.create(stack);
                if (!result.isPresent()) continue;
                this.setNewResource(index, ((ResourceAmount)result.get()).resource());
                return;
            }
        }
        if (this.primaryResourceFactory != null) {
            this.primaryResourceFactory.create(stack).ifPresentOrElse(resource -> this.setNewResource(index, resource.resource()), () -> this.remove(index));
        }
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (this.isFilter) {
            return;
        }
        if (this.slots[slot] == null && !stack.method_7960()) {
            this.setNewResource(slot, (ResourceKey)ItemResource.ofItemStack((class_1799)stack));
        } else if (this.slots[slot] != null && stack.method_7960()) {
            this.remove(slot);
        }
    }

    public void remove(int index) {
        this.slots[index] = null;
    }

    public void setNewResource(int index, ResourceKey resourceKey) {
        this.set(index, new ResourceMinMaxAmount(resourceKey, 0L, 0L, 1L, false));
    }

    public void set(int index, ResourceMinMaxAmount resourceAmount) {
        this.slots[index] = resourceAmount;
    }

    public void setMinAmount(int index, long amount) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        this.slots[index] = slot.toBuilder().minAmount(amount).build();
    }

    public long getMinAmount(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return this.slots[index].minAmount();
    }

    public void setMaxAmount(int index, long amount) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        this.slots[index] = slot.toBuilder().maxAmount(amount).build();
    }

    public long getMaxAmount(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return this.slots[index].maxAmount();
    }

    public void setBatchSize(int index, long amount) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        this.slots[index] = slot.toBuilder().batchSize(amount).build();
    }

    public long getBatchSize(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return this.slots[index].batchSize();
    }

    public boolean isCrafting(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return false;
        }
        return this.slots[index].isCrafting();
    }

    @Nullable
    public ResourceMinMaxAmount get(int index) {
        return this.slots[index];
    }

    @Nullable
    public PlatformResourceKey getResource(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return null;
        }
        return (PlatformResourceKey)slot.resource();
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (this.isFilter) {
            return true;
        }
        PatternState state = (PatternState)stack.method_57824(DataComponents.INSTANCE.getPatternState());
        return super.method_5437(slot, stack) && state != null && state.type() != PatternType.PROCESSING;
    }

    public int size() {
        return this.method_5439();
    }

    public boolean isActive(int slot) {
        return slot < 9 * (this.amountOfSlotUpgrades.get() + 1);
    }

    public boolean isEmpty(int index) {
        return this.get(index) == null;
    }

    protected final void changed(int index) {
        if (this.changedListener != null) {
            this.changedListener.accept(index);
        }
    }

    public class_2499 method_7660(class_7225.class_7874 provider) {
        class_2487 tag1 = ContainerUtil.write((class_1263)this, (class_7225.class_7874)provider);
        class_2487 tag2 = new class_2487();
        for (int i = 0; i < this.size(); ++i) {
            ResourceMinMaxAmount slot = this.slots[i];
            if (slot == null) continue;
            this.addToTag(tag2, i, slot, provider);
        }
        class_2499 listTag = new class_2499();
        listTag.add((Object)tag1);
        listTag.add((Object)tag2);
        return listTag;
    }

    private void addToTag(class_2487 tag, int index, ResourceMinMaxAmount slot, class_7225.class_7874 provider) {
        class_2520 serialized = (class_2520)ResourceMinMaxAmount.CODEC.encode((Object)slot, (DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2487()).getOrThrow();
        tag.method_10566("s" + index, serialized);
    }

    public void method_7659(class_2499 tag, class_7225.class_7874 provider) {
        ContainerUtil.read((class_2487)tag.method_10602(0), (class_1263)this, (class_7225.class_7874)provider);
        class_2487 tag2 = tag.method_10602(1);
        for (int i = 0; i < this.size(); ++i) {
            String key = "s" + i;
            if (!tag2.method_10545(key)) {
                this.slots[i] = null;
                continue;
            }
            class_2487 item = tag2.method_10562(key);
            this.fromTag(i, item, provider);
        }
    }

    private void fromTag(int index, class_2487 tag, class_7225.class_7874 provider) {
        ResourceMinMaxAmount.CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).resultOrPartial(error -> LOGGER.error("Failed to load resource container slot {} {}: {}", new Object[]{index, tag, error})).ifPresent(resourceAmount -> this.set(index, (ResourceMinMaxAmount)resourceAmount));
    }

    @Nullable
    public ResourceFactory getPrimaryResourceFactory() {
        return this.primaryResourceFactory;
    }

    @Nullable
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.alternativeResourceFactories;
    }
}

