/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support.patternresource;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceSlotAmountChangePacket;
import com.ultramega.stepcrafter.common.packet.s2c.PatternResourceSlotUpdatePacket;
import com.ultramega.stepcrafter.common.support.DisabledPatternResourceSlot;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class PatternResourceSlot
extends ValidatedSlot {
    private final PatternResourceContainerImpl container;
    private final class_2561 helpText;
    private final class_1937 level;
    private final boolean isFilter;
    @Nullable
    private ResourceMinMaxAmount cachedResource;

    public PatternResourceSlot(PatternResourceContainerImpl container, int index, class_2561 helpText, int x, int y, class_1937 level, boolean isFilter) {
        super((class_1263)container, index, x, y, stack -> container.method_5437(index, (class_1799)stack));
        this.container = container;
        this.helpText = helpText;
        this.level = level;
        this.isFilter = isFilter;
        this.cachedResource = this.container.get(index);
    }

    public PatternResourceSlot forAmountScreen(int newX, int newY) {
        return new DisabledPatternResourceSlot(this.container, this.method_34266(), this.helpText, newX, newY, this.level, this.isFilter);
    }

    public boolean isEmpty() {
        return this.container.isEmpty(this.method_34266());
    }

    public void change(class_1799 stack, boolean tryAlternatives) {
        this.container.change(this.method_34266(), stack, tryAlternatives);
    }

    public void change(@Nullable ResourceMinMaxAmount resourceAmount) {
        if (resourceAmount == null) {
            this.container.remove(this.method_34266());
        } else {
            this.container.set(this.method_34266(), resourceAmount);
        }
    }

    public void setFilter(PlatformResourceKey resource) {
        if (!this.isFilter) {
            return;
        }
        this.container.setNewResource(this.method_34266(), (ResourceKey)resource);
    }

    public boolean changeIfEmpty(class_1799 stack) {
        if (!this.isEmpty()) {
            return false;
        }
        this.container.setNewResource(this.method_34266(), (ResourceKey)ItemResource.ofItemStack((class_1799)stack));
        return true;
    }

    public void changeAmount(long minAmount, long maxAmount, long batchSize) {
        this.container.setMinAmount(this.field_7874, minAmount);
        this.container.setMaxAmount(this.field_7874, maxAmount);
        this.container.setBatchSize(this.field_7874, batchSize);
        this.container.changed(this.field_7874);
    }

    public void changeAmountOnClient(double minAmount, double maxAmount, double batchSize) {
        PlatformResourceKey resource = this.getResource();
        if (resource == null) {
            return;
        }
        long normalizedMinAmount = resource.getResourceType().normalizeAmount(minAmount);
        long normalizedMaxAmount = resource.getResourceType().normalizeAmount(maxAmount);
        long normalizedBatchSize = resource.getResourceType().normalizeAmount(batchSize);
        Platform.INSTANCE.sendPacketToServer((class_8710)new PatternResourceSlotAmountChangePacket(this.field_7874, normalizedMinAmount, normalizedMaxAmount, normalizedBatchSize));
    }

    @Nullable
    public PlatformResourceKey getResource() {
        return this.container.getResource(this.method_34266());
    }

    public long getMinAmount() {
        return this.container.getMinAmount(this.field_7874);
    }

    public long getMaxAmount() {
        return this.container.getMaxAmount(this.field_7874);
    }

    public long getBatchSize() {
        return this.container.getBatchSize(this.field_7874);
    }

    public boolean isCrafting() {
        return this.container.isCrafting(this.field_7874);
    }

    public boolean contains(class_1799 stack) {
        return class_1799.method_7973((class_1799)stack, (class_1799)this.method_7677());
    }

    public void broadcastChanges(class_1657 player) {
        ResourceMinMaxAmount currentResourceAmount = this.container.get(this.method_34266());
        if (!Objects.equals(currentResourceAmount, this.cachedResource)) {
            this.cachedResource = currentResourceAmount;
            this.broadcastChange((class_3222)player, currentResourceAmount);
        }
    }

    private void broadcastChange(class_3222 player, @Nullable ResourceMinMaxAmount contents) {
        Platform.INSTANCE.sendPacketToClient(player, (class_8710)new PatternResourceSlotUpdatePacket(this.field_7874, Optional.ofNullable(contents)));
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    public boolean method_7682() {
        return this.container.isActive(this.field_7874);
    }

    public boolean method_7674(class_1657 player) {
        return super.method_7674(player) && !this.isFilter;
    }

    public boolean method_7680(class_1799 stack) {
        return super.method_7680(stack) && !this.isFilter;
    }

    @Nullable
    public ResourceFactory getPrimaryResourceFactory() {
        return this.container.getPrimaryResourceFactory();
    }

    @Nullable
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.container.getAlternativeResourceFactories();
    }

    public class_2561 getHelpText() {
        return this.helpText;
    }
}

