/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.compat.emi;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceFilterSlotChangePacket;
import com.ultramega.stepcrafter.common.support.AbstractPatternResourceContainerMenu;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PatternResourceEmiDragDropHandler
implements EmiDragDropHandler<Screen> {
    public boolean dropStack(Screen screen, EmiIngredient stack, int x, int y) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return false;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        AbstractContainerMenu abstractContainerMenu = baseScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractPatternResourceContainerMenu)) {
            return false;
        }
        AbstractPatternResourceContainerMenu menu = (AbstractPatternResourceContainerMenu)abstractContainerMenu;
        return RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource((Object)stack).map(resource -> this.dropStack(menu, (AbstractBaseScreen<?>)baseScreen, (PlatformResourceKey)resource, x, y)).orElse(false);
    }

    private boolean dropStack(AbstractPatternResourceContainerMenu menu, AbstractBaseScreen<?> baseScreen, PlatformResourceKey resource, int x, int y) {
        for (PatternResourceSlot slot : menu.getPatternResourceSlots()) {
            if (!this.dropStack(resource, slot, x, y, baseScreen)) continue;
            return true;
        }
        return false;
    }

    private boolean dropStack(PlatformResourceKey resource, PatternResourceSlot slot, int x, int y, AbstractBaseScreen<?> baseScreen) {
        if (!PatternResourceEmiDragDropHandler.isSlotValid(slot)) {
            return false;
        }
        int slotX = baseScreen.getLeftPos() + slot.x;
        int slotY = baseScreen.getTopPos() + slot.y;
        if (x < slotX || y < slotY || x > slotX + 16 || y > slotY + 16) {
            return false;
        }
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new PatternResourceFilterSlotChangePacket(slot.index, resource));
        return true;
    }

    public void render(Screen screen, EmiIngredient dragged, GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (!(screen instanceof AbstractBaseScreen)) {
            return;
        }
        AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
        AbstractContainerMenu abstractContainerMenu = baseScreen.getMenu();
        if (!(abstractContainerMenu instanceof AbstractPatternResourceContainerMenu)) {
            return;
        }
        AbstractPatternResourceContainerMenu menu = (AbstractPatternResourceContainerMenu)abstractContainerMenu;
        RefinedStorageApi.INSTANCE.getIngredientConverter().convertToResource((Object)dragged).ifPresent(resource -> {
            EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
            for (PatternResourceSlot slot : menu.getPatternResourceSlots()) {
                if (!PatternResourceEmiDragDropHandler.isSlotValid(slot)) continue;
                context.fill(baseScreen.getLeftPos() + slot.x, baseScreen.getTopPos() + slot.y, 17, 17, -2010989773);
            }
        });
    }

    private static boolean isSlotValid(PatternResourceSlot slot) {
        return slot.isFilter() && slot.isActive();
    }
}

