/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.resourceconfiguration;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.support.amount.ActionButton;
import com.refinedmods.refinedstorage.common.support.amount.ActionIcon;
import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.mixin.ActionButtonInvoker;
import com.ultramega.stepcrafter.common.resourceconfiguration.ResourceConfigurationContainerMenu;
import com.ultramega.stepcrafter.common.support.AbstractAdvancedBaseScreen;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlotRendering;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;

public class ResourceConfigurationScreen
extends AbstractAdvancedBaseScreen<ResourceConfigurationContainerMenu>
implements PatternOutputRenderingScreen {
    private static final ResourceLocation TEXTURE_1 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/resource_configuration_1.png");
    private static final ResourceLocation TEXTURE_2 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/resource_configuration_2.png");
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation((String)"gui", (String)"configure_amount");
    private static final MutableComponent SET_TEXT = IdentifierUtil.createTranslation((String)"gui", (String)"configure_amount.set");
    private static final int ACTION_BUTTON_HEIGHT = 20;
    private static final int ACTION_BUTTON_WIDTH = 58;
    @Nullable
    protected ActionButton confirmButton;
    @Nullable
    protected EditBox minAmountField;
    @Nullable
    protected EditBox maxAmountField;
    @Nullable
    protected EditBox batchSizeField;
    private final Screen parent;
    private final PatternResourceSlot resourceSlot;
    private final AmountOperations<Double> amountOperations;
    private final double minInitialAmount;
    private final double maxInitialAmount;
    private final double batchSizeInitialAmount;
    private final boolean showBatchSize;
    private final double minAmount;
    private final double maxAmount;

    public ResourceConfigurationScreen(Screen parent, Inventory playerInventory, PatternResourceSlot resourceSlot, boolean showBatchSize) {
        super(new ResourceConfigurationContainerMenu(resourceSlot, 120 + (showBatchSize ? 25 : 0), 42), playerInventory, (Component)TITLE);
        this.parent = parent;
        this.resourceSlot = resourceSlot;
        this.amountOperations = DoubleAmountOperations.INSTANCE;
        this.minInitialAmount = resourceSlot.getMinAmount();
        this.maxInitialAmount = resourceSlot.getMaxAmount();
        this.batchSizeInitialAmount = resourceSlot.getBatchSize();
        this.showBatchSize = showBatchSize;
        this.minAmount = resourceSlot.getResource() != null ? resourceSlot.getResource().getResourceType().getDisplayAmount(0L) : 0.0;
        this.maxAmount = Double.MAX_VALUE;
        this.imageWidth = 179;
        this.imageHeight = 99;
    }

    protected void init() {
        super.init();
        this.addConfirmButton();
        this.addAmountFields();
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
    }

    protected void renderResourceSlots(GuiGraphics graphics) {
        PatternResourceSlotRendering.render(graphics, ((ResourceConfigurationContainerMenu)this.getMenu()).getResourceSlot(), this.leftPos, this.topPos);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.pose().popPose();
        int n = this.titleMarquee.getEffectiveWidth(this.font);
        Objects.requireNonNull(this.font);
        boolean hoveringOverTitle = this.isHovering(this.titleLabelX, this.titleLabelY, n, 9, mouseX, mouseY);
        this.titleMarquee.render(graphics, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, this.font, hoveringOverTitle);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        MutableComponent minText = Component.translatable((String)"gui.stepcrafter.resource_configuration.minimum");
        MutableComponent maxText = Component.translatable((String)"gui.stepcrafter.resource_configuration.maximum");
        MutableComponent batchSizeText = Component.translatable((String)"gui.stepcrafter.resource_configuration.batch_size");
        int biggestTextWidth = Math.max(this.font.width((FormattedText)minText), this.font.width((FormattedText)maxText));
        int width = 40;
        int y = 39;
        if (this.showBatchSize) {
            biggestTextWidth = Math.max(biggestTextWidth, this.font.width((FormattedText)batchSizeText));
            width += 27;
            y -= 6;
        }
        int x = (width - biggestTextWidth) / 2;
        graphics.drawString(this.font, (Component)minText, x, y, 0x404040, false);
        graphics.drawString(this.font, (Component)maxText, x, y + 14, 0x404040, false);
        if (this.showBatchSize) {
            graphics.drawString(this.font, (Component)batchSizeText, x, y + 28, 0x404040, false);
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        List<ClientTooltipComponent> tooltip;
        PatternResourceSlot patternSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof PatternResourceSlot && (patternSlot = (PatternResourceSlot)slot).getResource() != null && !(tooltip = this.getPatternResourceSlotTooltip((ResourceKey)patternSlot.getResource(), patternSlot)).isEmpty()) {
            Platform.INSTANCE.renderTooltip(graphics, tooltip, x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    @Override
    protected void addPatternResourceSlotTooltips(PatternResourceSlot slot, List<ClientTooltipComponent> tooltip) {
    }

    private void addAmountFields() {
        int x = this.leftPos + 40 + (this.showBatchSize ? 25 : 0);
        int y = this.topPos + 39 - (this.showBatchSize ? 6 : 0);
        int width = 62;
        String minOriginalValue = this.minAmountField != null ? this.minAmountField.getValue() : null;
        Objects.requireNonNull(this.font);
        this.minAmountField = new EditBox(this.font, x, y, 62, 9, (Component)Component.empty());
        this.minAmountField.setBordered(false);
        this.minAmountField.setTextColor(0xFFFFFF);
        if (minOriginalValue != null) {
            this.minAmountField.setValue(minOriginalValue);
            this.onAmountFieldChanged(this.minAmountField, 0);
        }
        this.updateAmount(this.minAmountField, this.minInitialAmount);
        this.minAmountField.setVisible(true);
        this.minAmountField.setCanLoseFocus(true);
        this.minAmountField.setFocused(true);
        this.minAmountField.setResponder(value -> {
            Triple<Optional<Double>, Optional<Double>, Optional<Double>> amounts;
            this.onAmountFieldChanged(this.minAmountField, 0);
            this.onAmountFieldChanged(this.maxAmountField, 1);
            if (this.maxAmountField != null && ((Optional)(amounts = this.getAndValidateAmount()).getLeft()).isPresent() && ((Optional)amounts.getMiddle()).isEmpty()) {
                this.maxAmountField.setValue(this.minAmountField.getValue());
            }
        });
        this.setFocused((GuiEventListener)this.minAmountField);
        this.addRenderableWidget((GuiEventListener)this.minAmountField);
        String maxOriginalValue = this.maxAmountField != null ? this.maxAmountField.getValue() : null;
        Objects.requireNonNull(this.font);
        this.maxAmountField = new EditBox(this.font, x, y + 14, 62, 9, (Component)Component.empty());
        this.maxAmountField.setBordered(false);
        this.maxAmountField.setTextColor(0xFFFFFF);
        if (maxOriginalValue != null) {
            this.maxAmountField.setValue(maxOriginalValue);
            this.onAmountFieldChanged(this.maxAmountField, 1);
        }
        this.updateAmount(this.maxAmountField, this.maxInitialAmount);
        this.maxAmountField.setVisible(true);
        this.maxAmountField.setCanLoseFocus(true);
        this.maxAmountField.setResponder(value -> this.onAmountFieldChanged(this.maxAmountField, 1));
        this.addRenderableWidget((GuiEventListener)this.maxAmountField);
        if (!this.showBatchSize) {
            return;
        }
        String batchOriginalValue = this.batchSizeField != null ? this.batchSizeField.getValue() : null;
        Objects.requireNonNull(this.font);
        this.batchSizeField = new EditBox(this.font, x, y + 28, 62, 9, (Component)Component.empty());
        this.batchSizeField.setBordered(false);
        this.batchSizeField.setTextColor(0xFFFFFF);
        if (batchOriginalValue != null) {
            this.batchSizeField.setValue(batchOriginalValue);
            this.onAmountFieldChanged(this.batchSizeField, 2);
        }
        this.updateAmount(this.batchSizeField, this.batchSizeInitialAmount);
        this.batchSizeField.setVisible(true);
        this.batchSizeField.setCanLoseFocus(true);
        this.batchSizeField.setResponder(value -> this.onAmountFieldChanged(this.batchSizeField, 2));
        this.addRenderableWidget((GuiEventListener)this.batchSizeField);
    }

    private void addConfirmButton() {
        ActionButton button = ActionButtonInvoker.create(this.leftPos + 116, this.topPos + 74, 58, 20, (Component)SET_TEXT, btn -> this.tryConfirm(true));
        button.setIcon(this.getConfirmButtonIcon());
        this.confirmButton = (ActionButton)this.addRenderableWidget((GuiEventListener)button);
    }

    @Nullable
    protected ActionIcon getConfirmButtonIcon() {
        return ActionIcon.SET;
    }

    protected final void updateAmount(@Nullable EditBox amountField, Double amount) {
        if (amountField == null) {
            return;
        }
        amountField.setValue(this.amountOperations.format((Number)amount));
    }

    protected void onAmountFieldChanged(@Nullable EditBox amountField, int type) {
        boolean thisValid;
        if (amountField == null) {
            return;
        }
        Triple<Optional<Double>, Optional<Double>, Optional<Double>> amounts = this.getAndValidateAmount();
        boolean valid = ((Optional)amounts.getLeft()).isPresent() && ((Optional)amounts.getMiddle()).isPresent() && ((Optional)amounts.getRight()).isPresent();
        switch (type) {
            case 0: {
                boolean bl = ((Optional)amounts.getLeft()).isPresent();
                break;
            }
            case 1: {
                boolean bl = ((Optional)amounts.getMiddle()).isPresent();
                break;
            }
            case 2: {
                boolean bl = ((Optional)amounts.getRight()).isPresent();
                break;
            }
            default: {
                boolean bl = thisValid = false;
            }
        }
        if (this.confirmButton != null) {
            this.confirmButton.active = valid;
            this.confirmButton.setIcon(valid ? this.getConfirmButtonIcon() : ActionIcon.ERROR);
        } else {
            this.tryConfirm(false);
        }
        amountField.setTextColor(thisValid ? 0xFFFFFF : 0xFF5555);
    }

    protected final Triple<Optional<Double>, Optional<Double>, Optional<Double>> getAndValidateAmount() {
        Optional<Double> batchSize;
        if (this.minAmountField == null || this.maxAmountField == null) {
            return Triple.of(Optional.empty(), Optional.empty(), Optional.empty());
        }
        Optional min = this.amountOperations.parse(this.minAmountField.getValue()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.minAmount, (Number)this.maxAmount));
        Optional<Object> max = this.amountOperations.parse(this.maxAmountField.getValue()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.minAmount, (Number)this.maxAmount));
        Optional<Double> optional = batchSize = this.batchSizeField != null ? this.amountOperations.parse(this.batchSizeField.getValue()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.minAmount, (Number)this.maxAmount)) : Optional.of(1.0);
        if (min.isPresent() && max.isPresent() && (Double)max.get() < (Double)min.get()) {
            max = Optional.empty();
        }
        return Triple.of(min, max, batchSize);
    }

    public boolean canDisplayOutput(ItemStack stack) {
        return true;
    }

    private void tryConfirm(boolean closeToParent) {
        Triple<Optional<Double>, Optional<Double>, Optional<Double>> amounts = this.getAndValidateAmount();
        if (((Optional)amounts.getLeft()).isPresent() && ((Optional)amounts.getMiddle()).isPresent() && ((Optional)amounts.getRight()).isPresent() && this.confirm((Double)((Optional)amounts.getLeft()).get(), (Double)((Optional)amounts.getMiddle()).get(), (Double)((Optional)amounts.getRight()).get()) && closeToParent) {
            this.tryCloseToParent();
        }
    }

    public void onClose() {
        this.tryCloseToParent();
    }

    private void tryCloseToParent() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    protected boolean confirm(Double newMinAmount, Double newMaxAmount, Double newBatchSize) {
        this.resourceSlot.changeAmountOnClient(newMinAmount, newMaxAmount, newBatchSize);
        return true;
    }

    @Override
    protected ResourceLocation getTexture() {
        return !this.showBatchSize ? TEXTURE_1 : TEXTURE_2;
    }
}

