/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepcrafter;

import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.UpgradeDestinations;
import com.ultramega.stepcrafter.common.registry.Items;
import com.ultramega.stepcrafter.common.registry.Menus;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterBlockEntity;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterData;
import com.ultramega.stepcrafter.common.stepcrafter.StepCrafterPropertyTypes;
import com.ultramega.stepcrafter.common.support.AbstractEditableNameContainerMenu;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StepCrafterContainerMenu
extends AbstractEditableNameContainerMenu {
    private static final int PATTERN_SLOT_X = 8;
    private static final int PATTERN_SLOT_Y = 20;
    @Nullable
    private StepCrafterBlockEntity stepCrafter;
    private int amountSlotUpgrades = 0;

    public StepCrafterContainerMenu(int syncId, Inventory playerInventory, StepCrafterData data) {
        super(Menus.INSTANCE.getStepCrafter(), syncId, playerInventory.player, null);
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.registerProperty((Property)new ClientProperty(StepCrafterPropertyTypes.VISIBLE_TO_THE_STEP_CRAFTER_MANAGER, (Object)true));
        this.addSlots(StepCrafterBlockEntity.createPatternResourcesContainer(data, () -> ((Player)playerInventory.player).level(), this::getAmountSlotUpgrades), new UpgradeContainer(8, (UpgradeDestination)UpgradeDestinations.STEP_CRAFTER, (c, upgradeEnergyUsage) -> {
            this.amountSlotUpgrades = c.getAmount((UpgradeItem)Items.INSTANCE.getSlotUpgrade());
            this.amountSlotUpgradesChanged(this.amountSlotUpgrades);
        }, 9));
        this.name = Component.empty();
    }

    public StepCrafterContainerMenu(int syncId, Inventory playerInventory, StepCrafterBlockEntity stepCrafter) {
        super(Menus.INSTANCE.getStepCrafter(), syncId, playerInventory.player, stepCrafter);
        this.stepCrafter = stepCrafter;
        this.name = stepCrafter.getDisplayName();
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((StepCrafterBlockEntity)stepCrafter).getRedstoneMode(), arg_0 -> ((StepCrafterBlockEntity)stepCrafter).setRedstoneMode(arg_0)));
        this.registerProperty((Property)new ServerProperty(StepCrafterPropertyTypes.VISIBLE_TO_THE_STEP_CRAFTER_MANAGER, stepCrafter::isVisibleToTheStepCrafterManager, stepCrafter::setVisibleToTheStepCrafterManager));
        this.addSlots(stepCrafter.getPatternResourceContainer(), stepCrafter.getUpgradeContainer());
    }

    public boolean stillValid(Player p) {
        if (this.stepCrafter == null) {
            return true;
        }
        return Container.stillValidBlockEntity((BlockEntity)this.stepCrafter, (Player)p);
    }

    @Override
    protected void addSlots(PatternResourceContainerImpl patternContainer, UpgradeContainer upgradeContainer) {
        for (int i = 0; i < patternContainer.getContainerSize(); ++i) {
            super.addSlot(this.createPatternSlot(patternContainer, i, this.player.level()));
        }
        super.addSlots(patternContainer, upgradeContainer);
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)patternContainer);
    }

    private Slot createPatternSlot(PatternResourceContainerImpl patternContainer, int index, Level level) {
        int x = 8 + index % 9 * 18;
        int y = 20 + index / 9 * 18;
        return new PatternResourceSlot(patternContainer, index, (Component)StepCrafterIdentifierUtil.createStepCrafterTranslation("gui", "step_crafter.filter_help"), x, y, level, false);
    }

    public boolean containsPattern(ItemStack stack) {
        for (Slot slot : this.slots) {
            PatternResourceSlot patternSlot;
            if (!(slot instanceof PatternResourceSlot) || (patternSlot = (PatternResourceSlot)slot).getItem() != stack) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getAmountSlotUpgrades() {
        return this.amountSlotUpgrades;
    }
}

