/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepmanager;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerViewType;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import com.ultramega.stepcrafter.common.packet.s2c.StepManagerActivePacket;
import com.ultramega.stepcrafter.common.stepcraftermanager.StepCrafterManagerContainerMenu;
import com.ultramega.stepcrafter.common.stepmanager.AbstractStepManagerBlockEntity;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerData;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerListener;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerSearchMode;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerSlot;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerWatcher;
import com.ultramega.stepcrafter.common.support.AbstractPatternResourceContainerMenu;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractStepManagerContainerMenu
extends AbstractPatternResourceContainerMenu
implements ScreenSizeListener,
StepManagerWatcher {
    private final Inventory playerInventory;
    private final List<ViewGroup> groups;
    private final List<StepManagerSlot> stepSlots = new ArrayList<StepManagerSlot>();
    @Nullable
    private StepManagerListener listener;
    @Nullable
    private AbstractStepManagerBlockEntity stepManager;
    private String query = "";
    private boolean active;

    public AbstractStepManagerContainerMenu(MenuType<? extends AbstractStepManagerContainerMenu> menu, int syncId, Inventory playerInventory, StepManagerData data) {
        super(menu, syncId, playerInventory.player);
        this.playerInventory = playerInventory;
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.groups = data.groups().stream().map(g -> ViewGroup.from(playerInventory.player.level(), g, this.isStepCrafterManager())).toList();
        this.active = data.active();
        this.resized(0, 0, 0);
    }

    protected AbstractStepManagerContainerMenu(MenuType<? extends AbstractStepManagerContainerMenu> menu, int syncId, Inventory playerInventory, AbstractStepManagerBlockEntity stepManager, List<AbstractStepManagerBlockEntity.Group> groups) {
        super(menu, syncId, playerInventory.player);
        this.playerInventory = playerInventory;
        this.stepManager = stepManager;
        this.stepManager.addWatcher(this);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((AbstractStepManagerBlockEntity)stepManager).getRedstoneMode(), arg_0 -> ((AbstractStepManagerBlockEntity)stepManager).setRedstoneMode(arg_0)));
        this.groups = Collections.emptyList();
        this.addServerSideSlots(groups);
    }

    public void removed(Player playerEntity) {
        super.removed(playerEntity);
        if (this.stepManager != null) {
            this.stepManager.removeWatcher(this);
        }
    }

    public boolean stillValid(Player player) {
        if (this.stepManager == null) {
            return true;
        }
        return Container.stillValidBlockEntity((BlockEntity)this.stepManager, (Player)player);
    }

    void setListener(StepManagerListener listener) {
        this.listener = listener;
    }

    void setQuery(String query) {
        this.query = query;
        this.notifyListener();
    }

    protected void notifyListener() {
        if (this.listener != null) {
            this.listener.slotsChanged();
        }
    }

    public boolean isStepCrafterManager() {
        return this instanceof StepCrafterManagerContainerMenu;
    }

    private void addServerSideSlots(List<AbstractStepManagerBlockEntity.Group> serverGroups) {
        for (AbstractStepManagerBlockEntity.Group group : serverGroups) {
            this.addServerSideSlots(group);
        }
        this.addPlayerInventory(this.playerInventory, 0, 0);
    }

    private void addServerSideSlots(AbstractStepManagerBlockEntity.Group group) {
        for (AbstractStepManagerBlockEntity.SubGroup subGroup : group.subGroups()) {
            PatternResourceContainerImpl container = subGroup.container();
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (!container.isActive(i)) continue;
                this.addSlot((Slot)new PatternResourceSlot(container, i, (Component)Component.empty(), 0, 0, this.playerInventory.player.level(), !this.isStepCrafterManager()));
            }
        }
    }

    public boolean containsPattern(ItemStack stack) {
        for (Slot slot : this.stepSlots) {
            if (slot.getItem() != stack) continue;
            return true;
        }
        return false;
    }

    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        this.initializeGroups(playerInventoryY, topYStart, topYEnd);
    }

    private void initializeGroups(int playerInventoryY, int topYStart, int topYEnd) {
        this.resetSlots();
        this.stepSlots.clear();
        int rowX = 8;
        int startY = topYStart - 18;
        int rowY = topYStart;
        for (ViewGroup group : this.groups) {
            rowY += this.initializeGroup(group, 8, rowY, startY, topYEnd);
        }
        this.addPlayerInventory(this.playerInventory, 8, playerInventoryY);
    }

    private int initializeGroup(ViewGroup group, int rowX, int rowY, int startY, int topYEnd) {
        int slotsWithinGroup = 0;
        for (SubViewGroup subGroup : group.subViewGroups) {
            int slotsWithinSubGroup = 0;
            boolean visible = this.active && this.isVisible(subGroup);
            for (int i = 0; i < subGroup.backingInventory.getContainerSize(); ++i) {
                if (!subGroup.backingInventory.isActive(i)) continue;
                int slotX = rowX + slotsWithinGroup % 9 * 18;
                int slotY = rowY + 18 + slotsWithinGroup / 9 * 18;
                boolean slotVisible = visible && this.isSlotVisible(this.playerInventory.player.level(), group, i);
                StepManagerSlot slot = new StepManagerSlot(subGroup.backingInventory, i, (Component)Component.empty(), slotX, slotY, IntIntPair.of((int)startY, (int)topYEnd), this.playerInventory.player.level(), !this.isStepCrafterManager(), slotVisible);
                this.addSlot((Slot)slot);
                if (!slotVisible) continue;
                this.stepSlots.add(slot);
                ++slotsWithinGroup;
                ++slotsWithinSubGroup;
            }
            subGroup.visibleSlots = slotsWithinSubGroup;
        }
        group.visibleSlots = slotsWithinGroup;
        if (slotsWithinGroup == 0) {
            return 0;
        }
        return (group.getVisibleRows() + 1) * 18;
    }

    private boolean isVisible(SubViewGroup subGroup) {
        return switch (this.getViewType()) {
            default -> throw new MatchException(null, null);
            case AutocrafterManagerViewType.VISIBLE -> subGroup.visibleToTheStepManager;
            case AutocrafterManagerViewType.NOT_FULL -> {
                if (!subGroup.full) {
                    yield true;
                }
                yield false;
            }
            case AutocrafterManagerViewType.ALL -> true;
        };
    }

    private boolean isSlotVisible(Level level, ViewGroup group, int index) {
        String normalizedQuery = this.query.trim().toLowerCase(Locale.ROOT);
        if (normalizedQuery.isEmpty()) {
            return true;
        }
        return this.getSearchMode().isSlotVisible(group, level, normalizedQuery, index);
    }

    List<ViewGroup> getGroups() {
        return this.groups;
    }

    List<StepManagerSlot> getStepSlots() {
        return this.stepSlots;
    }

    public abstract StepManagerSearchMode getSearchMode();

    public abstract void setSearchMode(StepManagerSearchMode var1);

    public abstract AutocrafterManagerViewType getViewType();

    public abstract void setViewType(AutocrafterManagerViewType var1);

    public void setActive(boolean active) {
        this.active = active;
        this.notifyListener();
    }

    boolean isActive() {
        return this.active;
    }

    @Override
    public void activeChanged(boolean newActive) {
        Player player = this.playerInventory.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            Platform.INSTANCE.sendPacketToClient(serverPlayerEntity, (CustomPacketPayload)new StepManagerActivePacket(newActive));
        }
    }

    @Override
    public int getAmountSlotUpgrades() {
        throw new UnsupportedOperationException("getAmountSlotUpgrades() is not supported on Step Crafter Manager.");
    }

    static class ViewGroup {
        private final String name;
        private final List<SubViewGroup> subViewGroups;
        private final List<SubViewGroup> subViewGroupsView;
        private int visibleSlots;

        private ViewGroup(String name, List<SubViewGroup> subViewGroups) {
            this.name = name;
            this.subViewGroups = subViewGroups;
            this.subViewGroupsView = Collections.unmodifiableList(subViewGroups);
        }

        private static ViewGroup from(Level level, StepManagerData.Group group, boolean isStepCrafterManager) {
            return new ViewGroup(group.name(), group.subGroups().stream().map(subGroup -> SubViewGroup.from(subGroup, level, isStepCrafterManager)).toList());
        }

        String getName() {
            return this.name;
        }

        List<SubViewGroup> getSubViewGroups() {
            return this.subViewGroupsView;
        }

        boolean isVisible() {
            return this.visibleSlots > 0;
        }

        int getVisibleRows() {
            return Math.ceilDiv(this.visibleSlots, 9);
        }

        boolean nameContains(String normalizedQuery) {
            return this.name.toLowerCase(Locale.ROOT).trim().contains(normalizedQuery);
        }

        boolean hasPatternInput(Level level, String normalizedQuery, int index) {
            return this.subViewGroups.stream().anyMatch(subGroup -> subGroup.hasPatternInput(level, normalizedQuery, index));
        }

        boolean hasPatternOutput(Level level, String normalizedQuery, int index) {
            return this.subViewGroups.stream().anyMatch(subGroup -> subGroup.hasPatternOutput(level, normalizedQuery, index));
        }
    }

    static class SubViewGroup {
        private final boolean visibleToTheStepManager;
        private final PatternResourceContainerImpl backingInventory;
        private final boolean full;
        private int visibleSlots;

        private SubViewGroup(boolean visibleToTheStepManager, PatternResourceContainerImpl backingInventory, boolean full) {
            this.visibleToTheStepManager = visibleToTheStepManager;
            this.backingInventory = backingInventory;
            this.full = full;
        }

        private static SubViewGroup from(StepManagerData.SubGroup subGroup, Level level, boolean isStepCrafterManager) {
            PatternResourceContainerImpl backingInventory = new PatternResourceContainerImpl(subGroup.slotCount(), () -> level, null, null, !isStepCrafterManager, subGroup::slotUpgradesCount);
            return new SubViewGroup(subGroup.visibleToTheStepManager(), backingInventory, subGroup.full());
        }

        int getVisibleSlots() {
            return this.visibleSlots;
        }

        boolean hasPatternInput(Level level, String normalizedQuery, int index) {
            ItemStack patternStack = this.backingInventory.getItem(index);
            return RefinedStorageApi.INSTANCE.getPattern(patternStack, level).map(pattern -> SubViewGroup.hasIngredient(pattern.layout().ingredients(), normalizedQuery)).orElse(false);
        }

        boolean hasPatternOutput(Level level, String normalizedQuery, int index) {
            ItemStack patternStack = this.backingInventory.getItem(index);
            return RefinedStorageApi.INSTANCE.getPattern(patternStack, level).map(pattern -> SubViewGroup.hasResource(pattern.layout().outputs(), normalizedQuery)).orElse(false);
        }

        private static boolean hasIngredient(List<Ingredient> ingredients, String normalizedQuery) {
            return ingredients.stream().flatMap(i -> i.inputs().stream()).anyMatch(key -> SubViewGroup.hasResource(normalizedQuery, key));
        }

        private static boolean hasResource(List<ResourceAmount> resources, String normalizedQuery) {
            return resources.stream().map(ResourceAmount::resource).anyMatch(key -> SubViewGroup.hasResource(normalizedQuery, key));
        }

        private static boolean hasResource(String normalizedQuery, ResourceKey key) {
            return RefinedStorageClientApi.INSTANCE.getResourceRendering(key.getClass()).getDisplayName(key).getString().toLowerCase(Locale.ROOT).trim().contains(normalizedQuery);
        }
    }
}

