/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepmanager;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.autocrafting.PatternOutputRenderingScreen;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.AutoSelectedSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceSlotChangePacket;
import com.ultramega.stepcrafter.common.stepmanager.AbstractStepManagerContainerMenu;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerSearchMode;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerSlot;
import com.ultramega.stepcrafter.common.stepmanager.widget.SearchModeSideButtonWidget;
import com.ultramega.stepcrafter.common.stepmanager.widget.ViewTypeSideButtonWidget;
import com.ultramega.stepcrafter.common.support.AbstractAdvancedBaseScreen;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlotRendering;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractStepManagerScreen<T extends AbstractStepManagerContainerMenu>
extends AbstractStretchingScreen<T>
implements PatternOutputRenderingScreen {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier((String)"textures/gui/autocrafter_manager.png");
    private static final List<String> SEARCH_FIELD_HISTORY = new ArrayList<String>();
    private static final ResourceLocation AUTOCRAFTER_NAME = IdentifierUtil.createIdentifier((String)"autocrafter_manager/autocrafter_name");
    private static final int COLUMNS = 9;
    private static final int INACTIVE_COLOR = -10790053;
    private static final MutableComponent HELP_ALL = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.all.help");
    private static final MutableComponent HELP_PATTERN_INPUTS = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.pattern_inputs.help");
    private static final MutableComponent HELP_PATTERN_OUTPUTS = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.pattern_outputs.help");
    private static final MutableComponent HELP_AUTOCRAFTER_NAMES = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.autocrafter_names.help");
    private final Inventory playerInventory;
    @Nullable
    private SearchFieldWidget searchField;
    @Nullable
    private List<ClientTooltipComponent> tooltip;

    public AbstractStepManagerScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, new TextMarquee(title, 70));
        this.playerInventory = playerInventory;
        this.inventoryLabelY = 75;
        this.imageWidth = 193;
        this.imageHeight = 176;
    }

    protected void init(int rows) {
        super.init(rows);
        ((AbstractStepManagerContainerMenu)this.getMenu()).setListener(() -> {
            this.resize();
            this.updateScrollbar();
            this.scrollbarChanged(rows);
        });
        if (this.searchField == null) {
            this.searchField = new SearchFieldWidget(this.font, this.leftPos + 94 + 1, this.topPos + 6 + 1, 67, new History(SEARCH_FIELD_HISTORY));
        } else {
            this.searchField.setX(this.leftPos + 94 + 1);
            this.searchField.setY(this.topPos + 6 + 1);
        }
        this.updateScrollbar();
        this.addWidget((GuiEventListener)this.searchField);
        this.searchField.setResponder(value -> ((AbstractStepManagerContainerMenu)this.getMenu()).setQuery((String)value));
        this.addRenderableWidget((GuiEventListener)new SearchIconWidget(this.leftPos + 79, this.topPos + 5, () -> this.getSearchModeHelp().copy().withStyle(ChatFormatting.GRAY), (EditBox)this.searchField));
        this.addSideButton((AbstractSideButtonWidget)new RedstoneModeSideButtonWidget(((AbstractStepManagerContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        this.addSideButton(new ViewTypeSideButtonWidget((AbstractStepManagerContainerMenu)this.getMenu()));
        this.addSideButton(new SearchModeSideButtonWidget((AbstractStepManagerContainerMenu)this.getMenu(), this::getSearchModeHelp, ((AbstractStepManagerContainerMenu)this.menu).isStepCrafterManager()));
        this.addSideButton((AbstractSideButtonWidget)new AutoSelectedSideButtonWidget(this.searchField));
    }

    private Component getSearchModeHelp() {
        return switch (((AbstractStepManagerContainerMenu)this.menu).getSearchMode()) {
            default -> throw new MatchException(null, null);
            case StepManagerSearchMode.ALL -> HELP_ALL;
            case StepManagerSearchMode.PATTERN_INPUTS -> HELP_PATTERN_INPUTS;
            case StepManagerSearchMode.PATTERN_OUTPUTS -> HELP_PATTERN_OUTPUTS;
            case StepManagerSearchMode.STEP_NAMES -> HELP_AUTOCRAFTER_NAMES;
        };
    }

    private void updateScrollbar() {
        int totalRows = ((AbstractStepManagerContainerMenu)this.menu).getGroups().stream().map(group -> group.isVisible() ? group.getVisibleRows() + 1 : 0).reduce(0, Integer::sum);
        this.updateScrollbar(totalRows);
    }

    protected void scrollbarChanged(int rows) {
        super.scrollbarChanged(rows);
        int scrollbarOffset = this.getScrollbarOffset();
        for (int i = 0; i < ((AbstractStepManagerContainerMenu)this.menu).getStepSlots().size(); ++i) {
            StepManagerSlot slot = ((AbstractStepManagerContainerMenu)this.menu).getStepSlots().get(i);
            Platform.INSTANCE.setSlotY((Slot)slot, slot.getOriginalY() - scrollbarOffset);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.searchField.render(graphics, 0, 0, 0.0f);
        }
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.keyPressed(key, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (((AbstractStepManagerContainerMenu)this.menu).isStepCrafterManager()) {
            PatternResourceSlot resourceSlot;
            Slot slot = this.hoveredSlot;
            if (slot instanceof PatternResourceSlot && (resourceSlot = (PatternResourceSlot)slot).isActive() && AbstractAdvancedBaseScreen.tryOpenResourceAmountScreen(this.minecraft, this.getMenu(), this.playerInventory, (Screen)this, resourceSlot, this.showBatchSize(), this.pressShiftToOpenConfig())) {
                return true;
            }
        } else {
            PatternResourceSlot resourceSlot;
            Slot slot = this.hoveredSlot;
            if (slot instanceof PatternResourceSlot && (resourceSlot = (PatternResourceSlot)slot).isActive()) {
                if (!AbstractAdvancedBaseScreen.tryOpenResourceAmountScreen(this.minecraft, this.getMenu(), this.playerInventory, (Screen)this, resourceSlot, this.showBatchSize(), this.pressShiftToOpenConfig())) {
                    Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new PatternResourceSlotChangePacket(this.hoveredSlot.index, clickedButton == 1));
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    protected abstract boolean showBatchSize();

    protected abstract boolean pressShiftToOpenConfig();

    protected void renderRows(GuiGraphics graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        if (!((AbstractStepManagerContainerMenu)this.menu).isActive()) {
            graphics.fill(RenderType.guiOverlay(), x + 7 + 1, y + 19 + 1, x + 7 + 162 - 1, y + 19 + 1 + 18 * rows - 2, -10790053);
            return;
        }
        this.renderGroups(graphics, x, y, topHeight, rows);
        this.renderSlotContents(graphics, mouseX, mouseY, y, topHeight, rows);
    }

    private void renderGroups(GuiGraphics graphics, int x, int y, int topHeight, int rows) {
        int rowX = x + 7;
        int rowY = y + topHeight - this.getScrollbarOffset();
        for (AbstractStepManagerContainerMenu.ViewGroup group : ((AbstractStepManagerContainerMenu)this.menu).getGroups()) {
            if (!group.isVisible()) continue;
            if (!AbstractStepManagerScreen.isOutOfFrame(y, topHeight, rows, rowY)) {
                graphics.blitSprite(AUTOCRAFTER_NAME, rowX, rowY, 162, 18);
                graphics.drawString(this.font, group.getName(), rowX + 4, rowY + 6, 0x404040, false);
            }
            AbstractStepManagerScreen.renderGroup(graphics, y, topHeight, rows, group, rowX, rowY);
            rowY += (group.getVisibleRows() + 1) * 18;
        }
    }

    private static void renderGroup(GuiGraphics graphics, int y, int topHeight, int rows, AbstractStepManagerContainerMenu.ViewGroup group, int rowX, int rowY) {
        int j = 0;
        for (AbstractStepManagerContainerMenu.SubViewGroup subGroup : group.getSubViewGroups()) {
            for (int i = 0; i < subGroup.getVisibleSlots(); ++i) {
                int slotX = rowX + j % 9 * 18;
                int slotY = rowY + 18 + j / 9 * 18;
                if (!AbstractStepManagerScreen.isOutOfFrame(y, topHeight, rows, slotY)) {
                    graphics.blitSprite(Sprites.SLOT, slotX, slotY, 18, 18);
                }
                ++j;
            }
        }
    }

    private void renderSlotContents(GuiGraphics graphics, int mouseX, int mouseY, int y, int topHeight, int rows) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        for (StepManagerSlot slot : ((AbstractStepManagerContainerMenu)this.menu).getStepSlots()) {
            boolean hovering;
            if (AbstractStepManagerScreen.isOutOfFrame(y, topHeight, rows, this.topPos + slot.y)) continue;
            if (((AbstractStepManagerContainerMenu)this.menu).isStepCrafterManager()) {
                super.renderSlot(graphics, (Slot)slot);
            } else {
                PatternResourceSlotRendering.render(graphics, slot, 0, 0);
            }
            boolean bl = hovering = mouseX >= slot.x + this.leftPos && mouseX < slot.x + this.leftPos + 16 && mouseY >= slot.y + this.topPos && mouseY < slot.y + this.topPos + 16;
            if (slot.isActive() && hovering) {
                PlatformResourceKey resource;
                AbstractStepManagerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)slot.x, (int)slot.y, (int)0);
                if (!((AbstractStepManagerContainerMenu)this.menu).isStepCrafterManager() && (resource = slot.getResource()) != null) {
                    this.tooltip = AbstractAdvancedBaseScreen.getTooltipsForResource((ResourceKey)resource);
                }
            }
            AbstractAdvancedBaseScreen.drawSlotMinMax(graphics, this.font, slot, 0, 0, this.showBatchSize());
        }
        graphics.pose().popPose();
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            Platform.INSTANCE.renderTooltip(graphics, this.tooltip, x, y);
            this.tooltip = null;
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof StepManagerSlot) {
            return;
        }
        super.renderSlot(guiGraphics, slot);
    }

    private static boolean isOutOfFrame(int y, int topHeight, int rows, int rowY) {
        return rowY < y + topHeight - 18 || rowY > y + topHeight + 18 * rows;
    }

    protected void renderStretchingBackground(GuiGraphics graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.blit(this.getTexture(), x, y + 18 * row, 0, textureY, this.imageWidth, 18);
        }
    }

    protected int getBottomHeight() {
        return 99;
    }

    protected int getBottomV() {
        return 73;
    }

    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public boolean canDisplayOutput(ItemStack stack) {
        return ((AbstractStepManagerContainerMenu)this.getMenu()).containsPattern(stack);
    }
}

