/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.stepmanager.widget;

import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.stepmanager.AbstractStepManagerContainerMenu;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerSearchMode;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SearchModeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode");
    private static final List<MutableComponent> SUBTEXT_ALL = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.all").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_PATTERN_INPUTS = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.pattern_inputs").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_PATTERN_OUTPUTS = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter_manager.search_mode.pattern_outputs").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_STEP_CRAFTER_NAMES = List.of(StepCrafterIdentifierUtil.createStepCrafterTranslation("gui", "step_crafter_manager.search_mode.step_crafter_names").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_STEP_REQUESTER_NAMES = List.of(StepCrafterIdentifierUtil.createStepCrafterTranslation("gui", "step_requester_manager.search_mode.step_requester_names").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation SPRITE_ALL = IdentifierUtil.createIdentifier((String)"widget/side_button/autocrafter_manager/search_mode/all");
    private static final ResourceLocation SPRITE_PATTERN_INPUTS = IdentifierUtil.createIdentifier((String)"widget/side_button/autocrafter_manager/search_mode/pattern_inputs");
    private static final ResourceLocation SPRITE_PATTERN_OUTPUTS = IdentifierUtil.createIdentifier((String)"widget/side_button/autocrafter_manager/search_mode/pattern_outputs");
    private static final ResourceLocation SPRITE_AUTOCRAFTER_NAMES = IdentifierUtil.createIdentifier((String)"widget/side_button/autocrafter_manager/search_mode/autocrafter_names");
    private final AbstractStepManagerContainerMenu containerMenu;
    private final Supplier<Component> helpTextSupplier;
    private final boolean isStepCrafterManager;

    public SearchModeSideButtonWidget(AbstractStepManagerContainerMenu containerMenu, Supplier<Component> helpTextSupplier, boolean isStepCrafterManager) {
        super(SearchModeSideButtonWidget.createPressAction(containerMenu));
        this.containerMenu = containerMenu;
        this.helpTextSupplier = helpTextSupplier;
        this.isStepCrafterManager = isStepCrafterManager;
    }

    private static Button.OnPress createPressAction(AbstractStepManagerContainerMenu containerMenu) {
        return btn -> containerMenu.setSearchMode(containerMenu.getSearchMode().toggle());
    }

    protected ResourceLocation getSprite() {
        return switch (this.containerMenu.getSearchMode()) {
            default -> throw new MatchException(null, null);
            case StepManagerSearchMode.ALL -> SPRITE_ALL;
            case StepManagerSearchMode.PATTERN_INPUTS -> SPRITE_PATTERN_INPUTS;
            case StepManagerSearchMode.PATTERN_OUTPUTS -> SPRITE_PATTERN_OUTPUTS;
            case StepManagerSearchMode.STEP_NAMES -> SPRITE_AUTOCRAFTER_NAMES;
        };
    }

    protected MutableComponent getTitle() {
        return TITLE;
    }

    protected List<MutableComponent> getSubText() {
        return switch (this.containerMenu.getSearchMode()) {
            default -> throw new MatchException(null, null);
            case StepManagerSearchMode.ALL -> SUBTEXT_ALL;
            case StepManagerSearchMode.PATTERN_INPUTS -> SUBTEXT_PATTERN_INPUTS;
            case StepManagerSearchMode.PATTERN_OUTPUTS -> SUBTEXT_PATTERN_OUTPUTS;
            case StepManagerSearchMode.STEP_NAMES -> this.isStepCrafterManager ? SUBTEXT_STEP_CRAFTER_NAMES : SUBTEXT_STEP_REQUESTER_NAMES;
        };
    }

    protected Component getHelpText() {
        return this.helpTextSupplier.get();
    }
}

