/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.steprequester;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionStrategy;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.SimpleConnectionStrategy;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.stepcrafter.common.ContentNames;
import com.ultramega.stepcrafter.common.Platform;
import com.ultramega.stepcrafter.common.UpgradeDestinations;
import com.ultramega.stepcrafter.common.registry.BlockEntities;
import com.ultramega.stepcrafter.common.registry.Items;
import com.ultramega.stepcrafter.common.steprequester.StepRequesterContainerMenu;
import com.ultramega.stepcrafter.common.steprequester.StepRequesterData;
import com.ultramega.stepcrafter.common.steprequester.StepRequesterNetworkNode;
import com.ultramega.stepcrafter.common.steprequester.StepRequesterNetworkNodeContainer;
import com.ultramega.stepcrafter.common.support.AbstractEditableNameBlockEntity;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerData;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceContainerImpl;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class StepRequesterBlockEntity
extends AbstractEditableNameBlockEntity<StepRequesterNetworkNode>
implements ExtendedMenuProvider<StepRequesterData>,
BlockEntityWithDrops {
    static final int UPGRADES = 8;
    static final int FILTERS = 45;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_RESOURCE_FILTER = "rf";
    private static final String TAG_VISIBLE_TO_THE_STEP_REQUESTER_MANAGER = "vsrm";
    private final PatternResourceContainerImpl filterContainer = StepRequesterBlockEntity.createFilterContainer(() -> ((StepRequesterBlockEntity)this).getLevel(), this::getSlotUpgradesCount);
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(8, (UpgradeDestination)UpgradeDestinations.STEP_REQUESTER, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getStepRequester().getEnergyUsage();
        ((StepRequesterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.speed = c.getAmount((UpgradeItem)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade()) * 2;
        this.slotUpgradesCount = c.getAmount((UpgradeItem)Items.INSTANCE.getSlotUpgrade());
        this.setChanged();
    });
    private boolean visibleToTheStepRequesterManager = true;
    private int speed = 0;
    private int slotUpgradesCount = 0;

    public StepRequesterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getStepRequester(), pos, state, new StepRequesterNetworkNode(Platform.INSTANCE.getConfig().getStepRequester().getEnergyUsage()));
        this.filterContainer.setChangedListener(i -> this.setChanged());
        ((StepRequesterNetworkNode)this.mainNetworkNode).setBlockEntity(this);
    }

    protected InWorldNetworkNodeContainer createMainContainer(StepRequesterNetworkNode networkNode) {
        return new StepRequesterNetworkNodeContainer(this, (NetworkNode)networkNode, "main", (ConnectionStrategy)new SimpleConnectionStrategy(this.getBlockPos()));
    }

    static PatternResourceContainerImpl createFilterContainer(Supplier<@NullableType Level> levelSupplier, Supplier<Integer> amountSupplier) {
        return new PatternResourceContainerImpl(45, levelSupplier, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories(), true, amountSupplier);
    }

    static PatternResourceContainerImpl createFilterContainer(StepRequesterData data, Supplier<@NullableType Level> levelSupplier, Supplier<Integer> amountSupplier) {
        PatternResourceContainerImpl filterContainer = StepRequesterBlockEntity.createFilterContainer(levelSupplier, amountSupplier);
        PatternResourceContainerData resourceContainerData = data.filterContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            resourceContainerData.resources().get(i).ifPresent(resource -> filterContainer.set(ii, (ResourceMinMaxAmount)resource));
        }
        return filterContainer;
    }

    UpgradeContainer getUpgradeContainer() {
        return this.upgradeContainer;
    }

    PatternResourceContainerImpl getFilterContainer() {
        return this.filterContainer;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getSlotUpgradesCount() {
        return this.slotUpgradesCount;
    }

    public Component getName() {
        Component customName = this.getCustomName();
        if (customName != null) {
            return customName;
        }
        return ContentNames.STEP_REQUESTER;
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new StepRequesterContainerMenu(syncId, inventory, this);
    }

    public StepRequesterData getMenuData() {
        return new StepRequesterData(PatternResourceContainerData.of(this.filterContainer));
    }

    public StreamEncoder<RegistryFriendlyByteBuf, StepRequesterData> getMenuCodec() {
        return StepRequesterData.STREAM_CODEC;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_RESOURCE_FILTER, (Tag)this.filterContainer.createTag(provider));
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putBoolean(TAG_VISIBLE_TO_THE_STEP_REQUESTER_MANAGER, this.visibleToTheStepRequesterManager);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_RESOURCE_FILTER)) {
            this.filterContainer.fromTag(tag.getList(TAG_RESOURCE_FILTER, 10), provider);
        }
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_VISIBLE_TO_THE_STEP_REQUESTER_MANAGER)) {
            this.visibleToTheStepRequesterManager = tag.getBoolean(TAG_VISIBLE_TO_THE_STEP_REQUESTER_MANAGER);
        }
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        drops.addAll((Collection)this.upgradeContainer.getDrops());
        return drops;
    }

    boolean isVisibleToTheStepRequesterManager() {
        return this.visibleToTheStepRequesterManager;
    }

    void setVisibleToTheStepRequesterManager(boolean visibleToTheStepRequesterManager) {
        this.visibleToTheStepRequesterManager = visibleToTheStepRequesterManager;
        this.setChanged();
    }
}

