/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.ItemResourceRendering;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.resourceconfiguration.ResourceConfigurationScreen;
import com.ultramega.stepcrafter.common.support.AbstractPatternResourceContainerMenu;
import com.ultramega.stepcrafter.common.support.patternresource.PatternResourceSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractAdvancedBaseScreen<T extends AbstractContainerMenu>
extends AbstractBaseScreen<T> {
    private static final SmallTextClientTooltipComponent SHIFT_CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((Component)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.shift_click_to_clear"));
    private static final Component SHIFT_CLICK_TO_CONFIGURE_AMOUNT = StepCrafterIdentifierUtil.createStepCrafterTranslationAsHeading("gui", "filter_slot.shift_click_to_configure_amount");
    private static final Component CLICK_TO_CONFIGURE_AMOUNT = IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.click_to_configure_amount");
    private static final ClientTooltipComponent EMPTY_FILTER = ClientTooltipComponent.create((FormattedCharSequence)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"filter_slot.empty_filter").getVisualOrderText());
    private static final ClientTooltipComponent EMPTY_PATTERN_SLOT = ClientTooltipComponent.create((FormattedCharSequence)IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"autocrafter.empty_pattern_slot").getVisualOrderText());
    private static final ResourceLocation TEXTURE_0 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_0.png");
    private static final ResourceLocation TEXTURE_1 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_1.png");
    private static final ResourceLocation TEXTURE_2 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_2.png");
    private static final ResourceLocation TEXTURE_3 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_3.png");
    private static final ResourceLocation TEXTURE_4 = StepCrafterIdentifierUtil.createStepCrafterIdentifier("textures/gui/step_crafter_requester_4.png");
    protected final Inventory playerInventory;
    private int lastAmountSlotUpgrades = -1;

    public AbstractAdvancedBaseScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.playerInventory = playerInventory;
        this.imageWidth = 228;
        this.determineStuff();
    }

    protected AbstractAdvancedBaseScreen(T menu, Inventory playerInventory, TextMarquee title) {
        super(menu, playerInventory, title);
        this.playerInventory = playerInventory;
        this.imageWidth = 228;
        this.determineStuff();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.determineStuff();
        super.render(graphics, mouseX, mouseY, delta);
    }

    protected void renderSlotMinMax(GuiGraphics graphics, boolean showBatchSize) {
        AbstractContainerMenu abstractContainerMenu = this.getMenu();
        if (!(abstractContainerMenu instanceof AbstractPatternResourceContainerMenu)) {
            return;
        }
        AbstractPatternResourceContainerMenu patternContainerMenu = (AbstractPatternResourceContainerMenu)abstractContainerMenu;
        for (PatternResourceSlot slot : patternContainerMenu.getPatternResourceSlots()) {
            AbstractAdvancedBaseScreen.drawSlotMinMax(graphics, this.font, slot, this.leftPos, this.topPos, showBatchSize);
        }
    }

    public static void drawSlotMinMax(GuiGraphics graphics, Font font, PatternResourceSlot slot, int leftPos, int topPos, boolean showBatchSize) {
        PoseStack poseStack = graphics.pose();
        if (slot.isActive() && slot.getResource() != null) {
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(slot.getResource().getClass());
            String formattedMinAmount = rendering.formatAmount(slot.getMinAmount(), true);
            String formattedMaxAmount = rendering.formatAmount(slot.getMaxAmount(), true);
            poseStack.pushPose();
            poseStack.translate((float)(leftPos + slot.x), (float)(topPos + slot.y), 260.0f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            graphics.drawString(font, formattedMinAmount, 0, 0, 0xFFFFFF);
            if (showBatchSize) {
                String formattedBatchSize = ItemResourceRendering.INSTANCE.formatAmount(slot.getBatchSize(), true);
                graphics.drawString(font, formattedBatchSize, 0, 12, 0xFFFFFF);
            }
            graphics.drawString(font, formattedMaxAmount, 0, 24, 0xFFFFFF);
            if (slot.isCrafting()) {
                graphics.blitSprite(Sprites.AUTOCRAFTING_INDICATOR, 22, -2, 10, 10);
            }
            poseStack.popPose();
        }
    }

    private void determineStuff() {
        int amountSlotUpgrades = 0;
        AbstractContainerMenu abstractContainerMenu = this.getMenu();
        if (abstractContainerMenu instanceof AbstractPatternResourceContainerMenu) {
            AbstractPatternResourceContainerMenu patternContainerMenu = (AbstractPatternResourceContainerMenu)abstractContainerMenu;
            amountSlotUpgrades = patternContainerMenu.getAmountSlotUpgrades();
        }
        if (this.lastAmountSlotUpgrades == amountSlotUpgrades) {
            return;
        }
        this.inventoryLabelY = 42 + amountSlotUpgrades * 18;
        this.imageHeight = 137 + amountSlotUpgrades * 18;
        if (this.lastAmountSlotUpgrades != -1) {
            this.init();
        }
        this.lastAmountSlotUpgrades = amountSlotUpgrades;
    }

    protected boolean tryOpenResourceAmountScreen(PatternResourceSlot slot, boolean showBatchSize, boolean hasToPressShift) {
        return AbstractAdvancedBaseScreen.tryOpenResourceAmountScreen(this.minecraft, this.getMenu(), this.playerInventory, (Screen)this, slot, showBatchSize, hasToPressShift);
    }

    public static boolean tryOpenResourceAmountScreen(@Nullable Minecraft minecraft, AbstractContainerMenu containerMenu, Inventory playerInventory, Screen parent, PatternResourceSlot slot, boolean showBatchSize, boolean hasToPressShift) {
        boolean canOpen;
        boolean isFilterSlot = slot.getResource() != null;
        boolean isNotTryingToRemoveFilter = hasToPressShift == AbstractAdvancedBaseScreen.hasShiftDown();
        boolean isNotCarryingItem = containerMenu.getCarried().isEmpty();
        boolean bl = canOpen = isFilterSlot && isNotTryingToRemoveFilter && isNotCarryingItem;
        if (canOpen && minecraft != null) {
            minecraft.setScreen((Screen)new ResourceConfigurationScreen(parent, playerInventory, slot, showBatchSize));
        }
        return canOpen;
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof PatternResourceSlot) {
            PatternResourceSlot patternSlot = (PatternResourceSlot)slot;
            List<ClientTooltipComponent> tooltip = this.getPatternResourceSlotTooltip(this.menu.getCarried(), patternSlot);
            if (!tooltip.isEmpty()) {
                Platform.INSTANCE.renderTooltip(graphics, tooltip, x, y);
                return;
            }
        }
        super.renderTooltip(graphics, x, y);
    }

    public final List<ClientTooltipComponent> getPatternResourceSlotTooltip(ItemStack carried, PatternResourceSlot slot) {
        PlatformResourceKey resource = slot.getResource();
        if (resource == null) {
            return this.getTooltipForEmptyPatternResourceSlot(carried, slot);
        }
        return this.getPatternResourceSlotTooltip((ResourceKey)resource, slot);
    }

    protected List<ClientTooltipComponent> getPatternResourceSlotTooltip(ResourceKey resource, PatternResourceSlot slot) {
        List<ClientTooltipComponent> tooltip = AbstractAdvancedBaseScreen.getTooltipsForResource(resource);
        this.addPatternResourceSlotTooltips(slot, tooltip);
        return tooltip;
    }

    public static List<ClientTooltipComponent> getTooltipsForResource(ResourceKey resource) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).getTooltip(resource).stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList());
    }

    private List<ClientTooltipComponent> getTooltipForEmptyPatternResourceSlot(ItemStack carried, PatternResourceSlot slot) {
        ArrayList<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>();
        tooltip.add(slot.isFilter() ? EMPTY_FILTER : EMPTY_PATTERN_SLOT);
        tooltip.addAll(this.getPatternResourceSlotHelpTooltip(carried, slot));
        tooltip.add(HelpClientTooltipComponent.create((Component)slot.getHelpText()));
        return tooltip;
    }

    private List<ClientTooltipComponent> getPatternResourceSlotHelpTooltip(ItemStack carried, PatternResourceSlot slot) {
        if (carried.isEmpty() || slot.getPrimaryResourceFactory() == null || slot.getAlternativeResourceFactories() == null) {
            return Collections.emptyList();
        }
        ArrayList<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
        slot.getPrimaryResourceFactory().create(carried).ifPresent(primaryResourceInstance -> lines.add(MouseClientTooltipComponent.resource((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.LEFT, (ResourceKey)primaryResourceInstance.resource(), null)));
        for (ResourceFactory alternativeResourceFactory : slot.getAlternativeResourceFactories()) {
            Optional result = alternativeResourceFactory.create(carried);
            result.ifPresent(alternativeResourceInstance -> lines.add(MouseClientTooltipComponent.resource((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.RIGHT, (ResourceKey)alternativeResourceInstance.resource(), null)));
        }
        return lines;
    }

    protected void addPatternResourceSlotTooltips(PatternResourceSlot slot, List<ClientTooltipComponent> tooltip) {
        tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"tooltip.stepcrafter.resource_configuration.minimum_amount", (Object[])new Object[]{slot.getMinAmount()}).withStyle(ChatFormatting.GRAY).getVisualOrderText()));
        tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"tooltip.stepcrafter.resource_configuration.maximum_amount", (Object[])new Object[]{slot.getMaxAmount()}).withStyle(ChatFormatting.GRAY).getVisualOrderText()));
        if (slot.isFilter()) {
            tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"tooltip.stepcrafter.resource_configuration.batch_size", (Object[])new Object[]{slot.getBatchSize()}).withStyle(ChatFormatting.GRAY).getVisualOrderText()));
        }
        tooltip.add((ClientTooltipComponent)new SmallTextClientTooltipComponent(slot.isFilter() ? CLICK_TO_CONFIGURE_AMOUNT : SHIFT_CLICK_TO_CONFIGURE_AMOUNT));
        if (slot.isFilter()) {
            tooltip.add((ClientTooltipComponent)SHIFT_CLICK_TO_CLEAR);
        }
    }

    protected ResourceLocation getTexture() {
        return switch (this.lastAmountSlotUpgrades) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            case 4 -> TEXTURE_4;
            default -> TEXTURE_0;
        };
    }
}

