/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.Platform;
import com.ultramega.stepcrafter.common.packet.c2s.StepNameChangePacket;
import com.ultramega.stepcrafter.common.packet.s2c.StepNameUpdatePacket;
import com.ultramega.stepcrafter.common.support.AbstractEditableNameBlockEntity;
import com.ultramega.stepcrafter.common.support.AbstractPatternResourceContainerMenu;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public abstract class AbstractEditableNameContainerMenu
extends AbstractPatternResourceContainerMenu {
    protected Component name;
    private final RateLimiter nameRateLimiter = RateLimiter.create((double)0.5);
    @Nullable
    private final AbstractEditableNameBlockEntity<?> blockEntity;
    @Nullable
    private Listener listener;

    public AbstractEditableNameContainerMenu(@Nullable MenuType<?> type, int syncId, Player player, @Nullable AbstractEditableNameBlockEntity<?> blockEntity) {
        super(type, syncId, player);
        this.blockEntity = blockEntity;
    }

    void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity == null) {
            return;
        }
        if (this.nameRateLimiter.tryAcquire()) {
            this.detectNameChange();
        }
    }

    private void detectNameChange() {
        if (this.blockEntity == null) {
            return;
        }
        Component newName = this.blockEntity.getDisplayName();
        if (!newName.equals((Object)this.name)) {
            this.name = newName;
            Platform.INSTANCE.sendPacketToClient((ServerPlayer)this.player, (CustomPacketPayload)new StepNameUpdatePacket(newName));
        }
    }

    public void changeName(String newName) {
        if (this.blockEntity != null) {
            this.blockEntity.setCustomName(newName);
            this.detectNameChange();
        } else {
            Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new StepNameChangePacket(newName));
        }
    }

    public void nameChanged(Component newName) {
        if (this.listener != null) {
            this.listener.nameChanged(newName);
        }
    }

    public static interface Listener {
        public void nameChanged(Component var1);
    }
}

