/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ResourceMinMaxAmount(ResourceKey resource, long minAmount, long maxAmount, long batchSize, boolean isCrafting) {
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourceMinMaxAmount> STREAM_CODEC = StreamCodec.of((buf, resourceAmount) -> {
        ResourceKey resourceKey = resourceAmount.resource();
        if (!(resourceKey instanceof PlatformResourceKey)) {
            throw new DecoderException("Cannot encode non-platform resource key");
        }
        PlatformResourceKey platformResourceKey = (PlatformResourceKey)resourceKey;
        ResourceCodecs.STREAM_CODEC.encode(buf, (Object)platformResourceKey);
        buf.writeLong(resourceAmount.minAmount());
        buf.writeLong(resourceAmount.maxAmount());
        buf.writeLong(resourceAmount.batchSize());
        buf.writeBoolean(resourceAmount.isCrafting());
    }, buf -> {
        PlatformResourceKey resourceKey = (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode(buf);
        long minAmount = buf.readLong();
        long maxAmount = buf.readLong();
        long batchSize = buf.readLong();
        boolean isCrafting = buf.readBoolean();
        return new ResourceMinMaxAmount((ResourceKey)resourceKey, minAmount, maxAmount, batchSize, isCrafting);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<ResourceMinMaxAmount>> STREAM_OPTIONAL_CODEC = ByteBufCodecs.optional(STREAM_CODEC);
    public static final Codec<ResourceMinMaxAmount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceCodecs.CODEC.fieldOf("resource").forGetter(resourceAmount -> (PlatformResourceKey)resourceAmount.resource()), (App)Codec.LONG.fieldOf("minAmount").forGetter(ResourceMinMaxAmount::minAmount), (App)Codec.LONG.fieldOf("maxAmount").forGetter(ResourceMinMaxAmount::maxAmount), (App)Codec.LONG.fieldOf("batchSize").forGetter(ResourceMinMaxAmount::batchSize), (App)Codec.BOOL.fieldOf("isCrafting").forGetter(ResourceMinMaxAmount::isCrafting)).apply((Applicative)instance, ResourceMinMaxAmount::new));

    public ResourceMinMaxAmount {
        ResourceMinMaxAmount.validate(resource, minAmount, maxAmount, batchSize);
    }

    public static void validate(ResourceKey resource, long minAmount, long maxAmount, long batchSize) {
        CoreValidations.validateNotNegative((long)minAmount, (String)"Min amount must be non-negative");
        CoreValidations.validateNotNegative((long)maxAmount, (String)"Max amount must be non-negative");
        CoreValidations.validateNotNegative((long)batchSize, (String)"Batch Size must be non-negative");
        CoreValidations.validateNotNull((Object)resource, (String)"Resource must not be null");
    }

    public Builder toBuilder() {
        return new Builder().resource(this.resource).minAmount(this.minAmount).maxAmount(this.maxAmount).batchSize(this.batchSize).isCrafting(this.isCrafting);
    }

    public static final class Builder {
        private ResourceKey resource;
        private long minAmount;
        private long maxAmount;
        private long batchSize;
        private boolean isCrafting;

        private Builder() {
        }

        public Builder resource(ResourceKey newResource) {
            this.resource = newResource;
            return this;
        }

        public Builder minAmount(long newMinAmount) {
            this.minAmount = newMinAmount;
            return this;
        }

        public Builder maxAmount(long newMaxAmount) {
            this.maxAmount = newMaxAmount;
            return this;
        }

        public Builder batchSize(long newBatchSize) {
            this.batchSize = newBatchSize;
            return this;
        }

        public Builder isCrafting(boolean newIsCrafting) {
            this.isCrafting = newIsCrafting;
            return this;
        }

        public ResourceMinMaxAmount build() {
            return new ResourceMinMaxAmount(this.resource, this.minAmount, this.maxAmount, this.batchSize, this.isCrafting);
        }
    }
}

