/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.common.support.patternresource;

import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.stepcrafter.common.support.ResourceMinMaxAmount;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternResourceContainerImpl
extends PatternInventory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternResourceContainerImpl.class);
    private final ResourceMinMaxAmount[] slots;
    @Nullable
    private final ResourceFactory primaryResourceFactory;
    @Nullable
    private final Set<ResourceFactory> alternativeResourceFactories;
    private final boolean isFilter;
    private final Supplier<Integer> slotUpgradesCount;
    @Nullable
    private Consumer<Integer> changedListener;

    public PatternResourceContainerImpl(int size, Supplier<@NullableType Level> levelSupplier, @Nullable ResourceFactory primaryResourceFactory, @Nullable Set<ResourceFactory> alternativeResourceFactories, boolean isFilter, Supplier<Integer> slotUpgradesCount) {
        super(size, levelSupplier);
        this.slots = new ResourceMinMaxAmount[size];
        this.primaryResourceFactory = primaryResourceFactory;
        this.alternativeResourceFactories = alternativeResourceFactories;
        this.isFilter = isFilter;
        this.slotUpgradesCount = slotUpgradesCount;
    }

    public void setChangedListener(@Nullable Consumer<Integer> changedListener) {
        this.changedListener = changedListener;
    }

    public void change(int index, ItemStack stack, boolean tryAlternatives) {
        if (tryAlternatives && this.alternativeResourceFactories != null) {
            for (ResourceFactory resourceFactory : this.alternativeResourceFactories) {
                Optional result = resourceFactory.create(stack);
                if (!result.isPresent()) continue;
                this.setNewResource(index, ((ResourceAmount)result.get()).resource());
                return;
            }
        }
        if (this.primaryResourceFactory != null) {
            this.primaryResourceFactory.create(stack).ifPresentOrElse(resource -> this.setNewResource(index, resource.resource()), () -> this.remove(index));
        }
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        if (this.isFilter) {
            return;
        }
        if (this.slots[slot] == null && !stack.isEmpty()) {
            this.setNewResource(slot, (ResourceKey)ItemResource.ofItemStack((ItemStack)stack));
        } else if (this.slots[slot] != null && stack.isEmpty()) {
            this.remove(slot);
        }
    }

    public void remove(int index) {
        this.slots[index] = null;
    }

    public void setNewResource(int index, ResourceKey resourceKey) {
        this.set(index, new ResourceMinMaxAmount(resourceKey, 0L, 0L, 1L, false));
    }

    public void set(int index, ResourceMinMaxAmount resourceAmount) {
        this.slots[index] = resourceAmount;
    }

    public void setMinAmount(int index, long amount) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        this.slots[index] = slot.toBuilder().minAmount(amount).build();
    }

    public long getMinAmount(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return this.slots[index].minAmount();
    }

    public void setMaxAmount(int index, long amount) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        this.slots[index] = slot.toBuilder().maxAmount(amount).build();
    }

    public long getMaxAmount(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return this.slots[index].maxAmount();
    }

    public void setBatchSize(int index, long amount) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return;
        }
        this.slots[index] = slot.toBuilder().batchSize(amount).build();
    }

    public long getBatchSize(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return 0L;
        }
        return this.slots[index].batchSize();
    }

    public boolean isCrafting(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return false;
        }
        return this.slots[index].isCrafting();
    }

    @Nullable
    public ResourceMinMaxAmount get(int index) {
        return this.slots[index];
    }

    @Nullable
    public PlatformResourceKey getResource(int index) {
        ResourceMinMaxAmount slot = this.slots[index];
        if (slot == null) {
            return null;
        }
        return (PlatformResourceKey)slot.resource();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (this.isFilter) {
            return true;
        }
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        return super.canPlaceItem(slot, stack) && state != null && state.type() != PatternType.PROCESSING;
    }

    public int size() {
        return this.getContainerSize();
    }

    public boolean isActive(int slot) {
        return slot < 9 * (this.slotUpgradesCount.get() + 1);
    }

    public boolean isEmpty(int index) {
        return this.get(index) == null;
    }

    protected final void changed(int index) {
        if (this.changedListener != null) {
            this.changedListener.accept(index);
        }
    }

    public ListTag createTag(HolderLookup.Provider provider) {
        CompoundTag tag1 = ContainerUtil.write((Container)this, (HolderLookup.Provider)provider);
        CompoundTag tag2 = new CompoundTag();
        for (int i = 0; i < this.size(); ++i) {
            ResourceMinMaxAmount slot = this.slots[i];
            if (slot == null) continue;
            this.addToTag(tag2, i, slot, provider);
        }
        ListTag listTag = new ListTag();
        listTag.add((Object)tag1);
        listTag.add((Object)tag2);
        return listTag;
    }

    private void addToTag(CompoundTag tag, int index, ResourceMinMaxAmount slot, HolderLookup.Provider provider) {
        Tag serialized = (Tag)ResourceMinMaxAmount.CODEC.encode((Object)slot, (DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new CompoundTag()).getOrThrow();
        tag.put("s" + index, serialized);
    }

    public void fromTag(ListTag tag, HolderLookup.Provider provider) {
        ContainerUtil.read((CompoundTag)tag.getCompound(0), (Container)this, (HolderLookup.Provider)provider);
        CompoundTag tag2 = tag.getCompound(1);
        for (int i = 0; i < this.size(); ++i) {
            String key = "s" + i;
            if (!tag2.contains(key)) {
                this.slots[i] = null;
                continue;
            }
            CompoundTag item = tag2.getCompound(key);
            this.fromTag(i, item, provider);
        }
    }

    private void fromTag(int index, CompoundTag tag, HolderLookup.Provider provider) {
        ResourceMinMaxAmount.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> LOGGER.error("Failed to load resource container slot {} {}: {}", new Object[]{index, tag, error})).ifPresent(resourceAmount -> this.set(index, (ResourceMinMaxAmount)resourceAmount));
    }

    @Nullable
    public ResourceFactory getPrimaryResourceFactory() {
        return this.primaryResourceFactory;
    }

    @Nullable
    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.alternativeResourceFactories;
    }
}

