/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.neoforge;

import com.refinedmods.refinedstorage.common.Config;
import com.refinedmods.refinedstorage.common.autocrafting.autocraftermanager.AutocrafterManagerViewType;
import com.ultramega.stepcrafter.common.Config;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.stepmanager.StepManagerSearchMode;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigImpl
implements Config {
    private static final String ENERGY_USAGE = "energyUsage";
    private static final String SPEED_MULTIPLIER = "speedMultiplier";
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final Config.SimpleEnergySpeedUsageEntry stepCrafter = new SimpleEnergySpeedUsageEntryImpl(this, "stepCrafter", 6L, 14);
    private final Config.SimpleEnergyUsageEntry stepRequester = new SimpleEnergyUsageEntryImpl(this, "stepRequester", 6L);
    private final Config.StepManagerEntry stepCrafterManager = new StepManagerEntryImpl("stepCrafterManager", 16L);
    private final Config.StepManagerEntry stepRequesterManager = new StepManagerEntryImpl("stepRequesterManager", 16L);
    private final Config.SimpleEnergyUsageEntry slotUpgrade = new SimpleEnergyUsageEntryImpl(this, "slotUpgrade", 4L);

    public ConfigImpl() {
        this.spec = this.builder.build();
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public Config.SimpleEnergySpeedUsageEntry getStepCrafter() {
        return this.stepCrafter;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getStepRequester() {
        return this.stepRequester;
    }

    @Override
    public Config.StepManagerEntry getStepCrafterManager() {
        return this.stepCrafterManager;
    }

    @Override
    public Config.StepManagerEntry getStepRequesterManager() {
        return this.stepRequesterManager;
    }

    @Override
    public Config.SimpleEnergyUsageEntry getSlotUpgrade() {
        return this.slotUpgrade;
    }

    private static String translationKey(String value) {
        return StepCrafterIdentifierUtil.createStepCrafterTranslationKey("text.autoconfig", "option." + value);
    }

    private class SimpleEnergySpeedUsageEntryImpl
    extends SimpleEnergyUsageEntryImpl
    implements Config.SimpleEnergySpeedUsageEntry {
        private final ModConfigSpec.IntValue speedMultiplier;

        SimpleEnergySpeedUsageEntryImpl(ConfigImpl configImpl, String path, long energyDefaultValue, int speedDefaultValue) {
            super(configImpl, path, energyDefaultValue, false);
            this.speedMultiplier = configImpl.builder.translation(ConfigImpl.translationKey(path + ".speedMultiplier")).defineInRange(ConfigImpl.SPEED_MULTIPLIER, speedDefaultValue, 0, Integer.MAX_VALUE);
            configImpl.builder.pop();
        }

        @Override
        public int getSpeedMultiplier() {
            return (Integer)this.speedMultiplier.get();
        }
    }

    private class SimpleEnergyUsageEntryImpl
    implements Config.SimpleEnergyUsageEntry {
        private final ModConfigSpec.LongValue energyUsage;

        SimpleEnergyUsageEntryImpl(ConfigImpl configImpl, String path, long defaultValue) {
            this(configImpl, path, defaultValue, true);
        }

        SimpleEnergyUsageEntryImpl(ConfigImpl configImpl, String path, long defaultValue, boolean pop) {
            configImpl.builder.translation(ConfigImpl.translationKey(path)).push(path);
            this.energyUsage = configImpl.builder.translation(ConfigImpl.translationKey(path + ".energyUsage")).defineInRange(ConfigImpl.ENERGY_USAGE, defaultValue, 0L, Long.MAX_VALUE);
            if (pop) {
                configImpl.builder.pop();
            }
        }

        public long getEnergyUsage() {
            return (Long)this.energyUsage.get();
        }
    }

    private class StepManagerEntryImpl
    extends SimpleEnergyUsageEntryImpl
    implements Config.StepManagerEntry {
        private final ModConfigSpec.EnumValue<StepManagerSearchMode> searchMode;
        private final ModConfigSpec.EnumValue<AutocrafterManagerViewType> viewType;

        StepManagerEntryImpl(String path, long energyDefaultValue) {
            super(ConfigImpl.this, path, energyDefaultValue, false);
            this.searchMode = ConfigImpl.this.builder.translation(ConfigImpl.translationKey(path + ".searchMode")).defineEnum("searchMode", (Enum)StepManagerSearchMode.ALL);
            this.viewType = ConfigImpl.this.builder.translation(ConfigImpl.translationKey(path + ".viewType")).defineEnum("viewType", (Enum)AutocrafterManagerViewType.VISIBLE);
            ConfigImpl.this.builder.pop();
        }

        @Override
        public void setSearchMode(StepManagerSearchMode searchMode) {
            if (searchMode != this.searchMode.get()) {
                this.searchMode.set((Object)searchMode);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public StepManagerSearchMode getSearchMode() {
            return (StepManagerSearchMode)((Object)this.searchMode.get());
        }

        @Override
        public void setViewType(AutocrafterManagerViewType viewType) {
            if (viewType != this.viewType.get()) {
                this.viewType.set((Object)viewType);
                ConfigImpl.this.spec.save();
            }
        }

        @Override
        public AutocrafterManagerViewType getViewType() {
            return (AutocrafterManagerViewType)this.viewType.get();
        }
    }
}

