/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.neoforge;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.BlockEntityTypeFactory;
import com.refinedmods.refinedstorage.common.content.ExtendedMenuTypeFactory;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.ultramega.stepcrafter.common.AbstractModInitializer;
import com.ultramega.stepcrafter.common.PlatformProxy;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceFilterSlotChangePacket;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceSlotAmountChangePacket;
import com.ultramega.stepcrafter.common.packet.c2s.PatternResourceSlotChangePacket;
import com.ultramega.stepcrafter.common.packet.c2s.RequestMaintainableResourcesPacket;
import com.ultramega.stepcrafter.common.packet.c2s.StepNameChangePacket;
import com.ultramega.stepcrafter.common.packet.s2c.PatternResourceSlotUpdatePacket;
import com.ultramega.stepcrafter.common.packet.s2c.SetMaintainableResourcesPacket;
import com.ultramega.stepcrafter.common.packet.s2c.StepManagerActivePacket;
import com.ultramega.stepcrafter.common.packet.s2c.StepNameUpdatePacket;
import com.ultramega.stepcrafter.common.registry.BlockEntities;
import com.ultramega.stepcrafter.common.registry.CreativeModeTabItems;
import com.ultramega.stepcrafter.neoforge.ClientModInitializer;
import com.ultramega.stepcrafter.neoforge.PlatformImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="stepcrafter")
public class ModInitializer
extends AbstractModInitializer {
    private final DeferredRegister<Block> blockRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"stepcrafter");
    private final DeferredRegister<Item> itemRegistry = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"stepcrafter");
    private final DeferredRegister<BlockEntityType<?>> blockEntityTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"stepcrafter");
    private final DeferredRegister<MenuType<?>> menuTypeRegistry = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"stepcrafter");

    public ModInitializer(IEventBus eventBus, ModContainer modContainer) {
        PlatformProxy.loadPlatform(new PlatformImpl(modContainer));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            eventBus.addListener(ClientModInitializer::onClientSetup);
            eventBus.addListener(ClientModInitializer::onRegisterMenuScreens);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        eventBus.addListener(this::onCommonSetup);
        this.registerContent(eventBus);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::registerPackets);
        eventBus.addListener(this::registerCreativeModeTabListener);
    }

    private void registerContent(IEventBus eventBus) {
        this.registerBlocks(eventBus);
        this.registerItems(eventBus);
        this.registerBlockEntities(eventBus);
        this.registerMenus(eventBus);
    }

    private void registerBlocks(IEventBus eventBus) {
        super.registerBlocks(new ForgeRegistryCallback<Block>(this.blockRegistry));
        this.blockRegistry.register(eventBus);
    }

    private void registerItems(IEventBus eventBus) {
        ForgeRegistryCallback<Item> callback = new ForgeRegistryCallback<Item>(this.itemRegistry);
        super.registerItems(callback);
        this.itemRegistry.register(eventBus);
    }

    private void registerBlockEntities(IEventBus eventBus) {
        super.registerBlockEntities(new ForgeRegistryCallback(this.blockEntityTypeRegistry), new BlockEntityTypeFactory(this){

            public <T extends BlockEntity> BlockEntityType<T> create(BlockEntityProvider<T> factory, Block ... allowedBlocks) {
                return new BlockEntityType((arg_0, arg_1) -> factory.create(arg_0, arg_1), new HashSet<Block>(Arrays.asList(allowedBlocks)), null);
            }
        });
        this.blockEntityTypeRegistry.register(eventBus);
    }

    private void registerMenus(IEventBus eventBus) {
        super.registerMenus(new ForgeRegistryCallback(this.menuTypeRegistry), new ExtendedMenuTypeFactory(this){

            public <T extends AbstractContainerMenu, D> MenuType<T> create(ExtendedMenuTypeFactory.MenuSupplier<T, D> supplier, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
                return IMenuTypeExtension.create((syncId, inventory, buf) -> {
                    Object data = streamCodec.decode((Object)buf);
                    return supplier.create(syncId, inventory, data);
                });
            }
        });
        this.menuTypeRegistry.register(eventBus);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getStepCrafter());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getStepRequester());
        this.registerNetworkNodeContainerProvider(event, BlockEntities.INSTANCE.getStepCrafterManager());
    }

    private void registerNetworkNodeContainerProvider(RegisterCapabilitiesEvent event, BlockEntityType<? extends AbstractNetworkNodeContainerBlockEntity<?>> type) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), type, (be, side) -> be.getContainerProvider());
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("stepcrafter");
        registrar.playToServer(PatternResourceSlotChangePacket.PACKET_TYPE, PatternResourceSlotChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternResourceSlotChangePacket::handle));
        registrar.playToServer(PatternResourceSlotAmountChangePacket.PACKET_TYPE, PatternResourceSlotAmountChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternResourceSlotAmountChangePacket::handle));
        registrar.playToServer(PatternResourceFilterSlotChangePacket.PACKET_TYPE, PatternResourceFilterSlotChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternResourceFilterSlotChangePacket::handle));
        registrar.playToServer(RequestMaintainableResourcesPacket.PACKET_TYPE, RequestMaintainableResourcesPacket.STREAM_CODEC, ModInitializer.wrapHandler(RequestMaintainableResourcesPacket::handle));
        registrar.playToServer(StepNameChangePacket.PACKET_TYPE, StepNameChangePacket.STREAM_CODEC, ModInitializer.wrapHandler(StepNameChangePacket::handle));
        registrar.playToClient(PatternResourceSlotUpdatePacket.PACKET_TYPE, PatternResourceSlotUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(PatternResourceSlotUpdatePacket::handle));
        registrar.playToClient(SetMaintainableResourcesPacket.PACKET_TYPE, SetMaintainableResourcesPacket.STREAM_CODEC, ModInitializer.wrapHandler(SetMaintainableResourcesPacket::handle));
        registrar.playToClient(StepNameUpdatePacket.PACKET_TYPE, StepNameUpdatePacket.STREAM_CODEC, ModInitializer.wrapHandler(StepNameUpdatePacket::handle));
        registrar.playToClient(StepManagerActivePacket.PACKET_TYPE, StepManagerActivePacket.STREAM_CODEC, ModInitializer.wrapHandler(StepManagerActivePacket::handle));
    }

    private void registerCreativeModeTabListener(BuildCreativeModeTabContentsEvent e) {
        ResourceKey creativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getCreativeModeTabId());
        ResourceKey coloredCreativeModeTab = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)RefinedStorageApi.INSTANCE.getColoredCreativeModeTabId());
        if (e.getTabKey().equals(creativeModeTab)) {
            CreativeModeTabItems.appendBlocks(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
        } else if (e.getTabKey().equals(coloredCreativeModeTab)) {
            CreativeModeTabItems.appendColoredVariants(arg_0 -> ((BuildCreativeModeTabContentsEvent)e).accept(arg_0));
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent e) {
        super.initializePlatformApi();
        this.registerUpgradeMappings();
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle((Object)packet, () -> ((IPayloadContext)ctx).player());
    }

    private record ForgeRegistryCallback<T>(DeferredRegister<T> registry) implements RegistryCallback<T>
    {
        public <R extends T> Supplier<R> register(ResourceLocation id, Supplier<R> value) {
            return this.registry.register(id.getPath(), value);
        }
    }
}

