/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.neoforge.datagen;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.registry.Blocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockModelProviderImpl
extends BlockModelProvider {
    private static final String PARTICLE_TEXTURE = "particle";
    private static final String CUTOUT_TEXTURE = "cutout";
    private static final String BLOCK_PREFIX = "block";
    private static final ResourceLocation EMISSIVE_NORTH_CUTOUT = IdentifierUtil.createIdentifier((String)"block/emissive_north_cutout");
    private static final ResourceLocation NORTH_CUTOUT = IdentifierUtil.createIdentifier((String)"block/north_cutout");
    private static final ResourceLocation BOTTOM_TEXTURE = IdentifierUtil.createIdentifier((String)"block/bottom");
    private static final String NORTH = "north";
    private static final String EAST = "east";
    private static final String SOUTH = "south";
    private static final String WEST = "west";
    private static final String UP = "up";
    private static final String DOWN = "down";

    public BlockModelProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "stepcrafter", existingFileHelper);
    }

    protected void registerModels() {
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getStepCrafterManager(), "step_crafter_manager");
        this.registerRightLeftBackFrontTopModel(Blocks.INSTANCE.getStepRequesterManager(), "step_requester_manager");
    }

    private void registerRightLeftBackFrontTopModel(BlockColorMap<?, ?> blockMap, String name) {
        this.registerRightLeftBackFrontTopModel(blockMap, name, "");
    }

    private void registerRightLeftBackFrontTopModel(BlockColorMap<?, ?> blockMap, String name, String modelPrefix) {
        blockMap.forEach((color, id, block) -> {
            ResourceLocation cutout = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/cutouts/" + color.getName());
            this.registerRightLeftBackFrontTopModel(name, modelPrefix + color.getName(), cutout, EMISSIVE_NORTH_CUTOUT);
        });
        ResourceLocation inactiveCutout = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/cutouts/inactive");
        this.registerRightLeftBackFrontTopModel(name, "inactive", inactiveCutout, NORTH_CUTOUT);
    }

    private void registerRightLeftBackFrontTopModel(String name, String variantName, ResourceLocation cutout, ResourceLocation baseModel) {
        ResourceLocation right = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/right");
        ResourceLocation left = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/left");
        ResourceLocation back = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/back");
        ResourceLocation front = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/front");
        ResourceLocation top = StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/top");
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)super.withExistingParent("block/" + name + "/" + variantName, baseModel)).texture(PARTICLE_TEXTURE, right)).texture(NORTH, front)).texture(EAST, right)).texture(SOUTH, back)).texture(WEST, left)).texture(UP, top)).texture(DOWN, BOTTOM_TEXTURE)).texture(CUTOUT_TEXTURE, cutout);
    }
}

