/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.stepcrafter.neoforge.datagen;

import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.ultramega.stepcrafter.common.StepCrafterIdentifierUtil;
import com.ultramega.stepcrafter.common.registry.Blocks;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateProviderImpl
extends BlockStateProvider {
    private static final String BLOCK_PREFIX = "block";
    private final ExistingFileHelper existingFileHelper;

    public BlockStateProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "stepcrafter", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        this.registerStepCrafterManagers();
        this.registerStepRequesterManagers();
    }

    private void registerStepCrafterManagers() {
        Blocks.INSTANCE.getStepCrafterManager().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "step_crafter_manager"));
    }

    private void registerStepRequesterManagers() {
        Blocks.INSTANCE.getStepRequesterManager().forEach((color, id, block) -> this.configureActiveColoredDirectionalBlock(color, block, "step_requester_manager"));
    }

    private void configureActiveColoredDirectionalBlock(DyeColor color, Supplier<? extends Block> block, String name) {
        ModelFile inactive = this.modelFile(StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/inactive"));
        ModelFile active = this.modelFile(StepCrafterIdentifierUtil.createStepCrafterIdentifier("block/" + name + "/" + color.getName()));
        VariantBlockStateBuilder builder = super.getVariantBuilder(block.get());
        builder.forAllStates(blockState -> {
            ConfiguredModel.Builder model = ConfiguredModel.builder();
            if (Boolean.TRUE.equals(blockState.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE))) {
                model.modelFile(active);
            } else {
                model.modelFile(inactive);
            }
            BiDirection direction = (BiDirection)blockState.getValue((Property)BiDirectionType.INSTANCE.getProperty());
            this.addRotationFrontFacingNorth(model, direction);
            return model.build();
        });
    }

    private void addRotationFrontFacingNorth(ConfiguredModel.Builder<?> model, BiDirection direction) {
        int x = (int)direction.getVec().x();
        int y = (int)direction.getVec().y();
        int z = (int)direction.getVec().z();
        switch (direction) {
            case UP_EAST: 
            case UP_NORTH: 
            case UP_SOUTH: 
            case UP_WEST: 
            case DOWN_EAST: 
            case DOWN_WEST: 
            case DOWN_SOUTH: 
            case DOWN_NORTH: {
                model.rotationX(x * -1).rotationY(z);
                break;
            }
            case EAST: 
            case WEST: {
                model.rotationY(y + 180);
                break;
            }
            case NORTH: 
            case SOUTH: {
                model.rotationY(y);
            }
        }
    }

    private ModelFile modelFile(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }
}

