/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.nordic.block;

import dev.apexstudios.fantasyfurniture.block.ChandelierBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class NordicChandelierBlock
extends ChandelierBlock {
    public static final VoxelShape SHAPE = NordicChandelierBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public NordicChandelierBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPE);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.65;
        double z = (double)pos.getZ() + 0.5;
        double offset = 0.25;
        this.addParticles(level, x + offset, y, z - offset);
        this.addParticles(level, x - offset, y, z - offset);
        this.addParticles(level, x + offset, y, z + offset);
        this.addParticles(level, x - offset, y, z + offset);
    }

    private void addParticles(Level level, double x, double y, double z) {
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
    }
}

