package de.cech12.bucketlib;

import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.api.BucketLibComponents;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.crafting.BlockIngredient;
import de.cech12.bucketlib.api.crafting.EmptyIngredient;
import de.cech12.bucketlib.api.crafting.EntityIngredient;
import de.cech12.bucketlib.api.crafting.FluidIngredient;
import de.cech12.bucketlib.api.crafting.MilkIngredient;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.FluidStorageData;
import de.cech12.bucketlib.item.UniversalBucketDispenseBehaviour;
import de.cech12.bucketlib.item.UniversalBucketFluidStorage;
import de.cech12.bucketlib.item.crafting.BucketFillingShapedRecipe;
import de.cech12.bucketlib.item.crafting.BucketFillingShapelessRecipe;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BucketLibMod implements ModInitializer {

    public static class_3218 SERVER_LEVEL;

    public static class_9331<FluidStorageData> STORAGE = class_2378.method_10230(class_7923.field_49658, BucketLibComponents.FLUID_LOCATION,
            new class_9331.class_9332<FluidStorageData>().method_57881(FluidStorageData.CODEC).method_57882(FluidStorageData.STREAM_CODEC).method_57880()
    );

    static {
        class_2378.method_10230(class_7923.field_49658, BucketLibComponents.BUCKET_CONTENT_LOCATION, BucketLibComponents.BUCKET_CONTENT);

        class_2378.method_10230(class_7923.field_41189, BucketLib.id("bucket_filling_shaped"), BucketFillingShapedRecipe.Serializer.INSTANCE);
        class_2378.method_10230(class_7923.field_41189, BucketLib.id("bucket_filling_shapeless"), BucketFillingShapelessRecipe.Serializer.INSTANCE);
        CustomIngredientSerializer.register(BlockIngredient.Serializer.INSTANCE);
        CustomIngredientSerializer.register(EmptyIngredient.Serializer.INSTANCE);
        CustomIngredientSerializer.register(EntityIngredient.Serializer.INSTANCE);
        CustomIngredientSerializer.register(FluidIngredient.Serializer.INSTANCE);
        CustomIngredientSerializer.register(MilkIngredient.Serializer.INSTANCE);
    }

    private static final List<UniversalBucketItem> BUCKETS = new ArrayList<>();

    public BucketLibMod() {
        //remember server level to have an easy getter
        ServerTickEvents.END_SERVER_TICK.register(server -> SERVER_LEVEL = server.method_3847(class_1937.field_25179));
    }

    @Override
    public void onInitialize() {
        CommonLoader.init();
        //Ensure that the tags are initialized
        BucketLibTags.init();
    }

    public static void addBucket(UniversalBucketItem bucket) {
        BUCKETS.add(bucket);
        //register dispense behaviour
        class_2315.method_10009(bucket, UniversalBucketDispenseBehaviour.getInstance());
        // Register bucket storage
        FluidStorage.ITEM.registerForItems((stack, context) -> new UniversalBucketFluidStorage(context), bucket);
    }

    public static List<UniversalBucketItem> getRegisteredBuckets() {
        return Collections.unmodifiableList(BUCKETS);
    }

}
