package de.cech12.bucketlib.api.crafting;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.platform.Services;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FluidIngredient implements CustomIngredient {

    protected final class_3611 fluid;
    protected final class_6862<class_3611> tag;
    private List<class_6880<class_1792>> matchingStacks;

    private FluidIngredient(class_3611 fluid, class_6862<class_3611> tag) {
        this.fluid = fluid;
        this.tag = tag;
    }

    public FluidIngredient(Optional<class_2960> fluidOptional, Optional<class_6862<class_3611>> tagOptional) {
        this(fluidOptional.map(class_7923.field_41173::method_10223).filter(Optional::isPresent).map(reference -> reference.get().comp_349()).orElse(null), tagOptional.orElse(null));
    }

    public FluidIngredient(class_3611 fluid) {
        this(fluid, null);
    }

    public FluidIngredient(class_6862<class_3611> tag) {
        this((class_3611)null, tag);
    }

    private boolean isFluidCorrect(class_3611 fluid) {
        return fluid != null && (
                (this.fluid != null && fluid.method_15780(this.fluid))
                        || (this.tag != null && fluid.method_15785().method_15767(this.tag))
        );
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        class_2960 location = class_7923.field_41178.method_10221(itemStack.method_7909());
        //Mekansim tanks are not compatible: https://github.com/cech12/BucketLib/issues/55 | https://github.com/mekanism/Mekanism/issues/8335
        if ("mekanism".equals(location.method_12836()) && itemStack.getRecipeRemainder().method_7960()) {
            return false;
        }
        class_1799 container = itemStack.method_46651(1);
        Storage<FluidVariant> storage = ContainerItemContext.withConstant(container).find(FluidStorage.ITEM);
        StorageView<FluidVariant> fluidView = null;
        if (storage != null) {
            for (StorageView<FluidVariant> view : storage.nonEmptyViews()) {
                fluidView = view;
                break;
            }
        }
        if (fluidView == null) {
            return false;
        }
        return this.isFluidCorrect(fluidView.getResource().getFluid()) && fluidView.getAmount() == FluidConstants.BUCKET;
    }

    @Override
    public List<class_6880<class_1792>> getMatchingItems() {
        if (this.matchingStacks == null) {
            this.matchingStacks = new ArrayList<>();
            List<class_3611> fluids = new ArrayList<>();
            if (this.tag != null) {
                class_7923.field_41173.method_40286(this.tag).forEach(fluid -> fluids.add(fluid.comp_349()));
            } else if (this.fluid != null) {
                fluids.add(this.fluid);
            }
            for (class_3611 fluid : fluids) {
                //vanilla bucket
                class_1792 bucketItem = fluid.method_15774();
                if (!(bucketItem instanceof class_1755) || Services.BUCKET.getFluidOfBucketItem((class_1755) bucketItem) != fluid) {
                    continue; //skip fluids that have no vanilla bucket
                }
                this.matchingStacks.add(class_6880.method_40223(bucketItem));
                //bucket lib buckets
                BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                    if (universalBucketItem.canHoldFluid(fluid)) {
                        //this.matchingStacks.add(BucketLibUtil.addFluid(new ItemStack(universalBucketItem), fluid));
                        this.matchingStacks.add(class_6880.method_40223(universalBucketItem));
                    }
                });
            }
        }
        return this.matchingStacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer implements CustomIngredientSerializer<FluidIngredient> {

        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 NAME = BucketLib.id("fluid");

        private static final MapCodec<FluidIngredient> CODEC = RecordCodecBuilder.mapCodec(builder ->
                builder.group(
                        class_2960.field_25139.optionalFieldOf("fluid").forGetter(i -> Optional.of(class_7923.field_41173.method_10221(i.fluid))),
                        class_6862.method_40090(class_7923.field_41173.method_46765()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))
                ).apply(builder, FluidIngredient::new)
        );

        private static final class_9139<class_9129, FluidIngredient> PACKET_CODEC = class_9139.method_56437(
                FluidIngredient.Serializer::write,
                FluidIngredient.Serializer::read);

        private Serializer() {}

        @Override
        public class_2960 getIdentifier() {
            return NAME;
        }

        @Override
        public MapCodec<FluidIngredient> getCodec() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, FluidIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        @Nonnull
        private static FluidIngredient read(class_9129 buffer) {
            String fluid = buffer.method_19772();
            String tagId = buffer.method_19772();
            if (!tagId.isEmpty()) {
                class_6862<class_3611> tag = class_6862.method_40092(class_7924.field_41270, class_2960.method_60654(tagId));
                return new FluidIngredient(tag);
            }
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a fluid ingredient with no fluid or tag.");
            }
            Optional<class_6880.class_6883<class_3611>> fluidOptional = class_7923.field_41173.method_10223(class_2960.method_60654(fluid));
            if (fluidOptional.isEmpty()) {
                throw new IllegalArgumentException("Fluid resource location \"" + fluid + " \" could not be found.");
            }
            return new FluidIngredient(fluidOptional.get().comp_349());
        }

        private static void write(@Nonnull class_9129 buffer, @Nonnull FluidIngredient ingredient) {
            buffer.method_10814(ingredient.fluid != null ? Objects.requireNonNull(class_7923.field_41173.method_10221(ingredient.fluid)).toString() : "");
            buffer.method_10814(ingredient.tag != null ? ingredient.tag.comp_327().toString() : "");
        }
    }

}
