package de.cech12.bucketlib.api.crafting;

import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.util.BucketLibUtil;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;

public class MilkIngredient implements CustomIngredient {

    private List<class_6880<class_1792>> matchingStacks;

    public MilkIngredient() {
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        if (itemStack.method_7909() == class_1802.field_8103) {
            return true;
        }
        class_2960 location = class_7923.field_41178.method_10221(itemStack.method_7909());
        //Mekansim tanks are not compatible: https://github.com/cech12/BucketLib/issues/55 | https://github.com/mekanism/Mekanism/issues/8335
        if ("mekanism".equals(location.method_12836()) && itemStack.getRecipeRemainder().method_7960()) {
            return false;
        }
        return BucketLibUtil.containsMilk(itemStack.method_7972());
    }

    @Override
    public List<class_6880<class_1792>> getMatchingItems() {
        if (this.matchingStacks == null) {
            this.matchingStacks = new ArrayList<>();
            this.matchingStacks.add(class_6880.method_40223(class_1802.field_8103));
            BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                if (universalBucketItem.canMilkEntities()) {
                    //this.matchingStacks.add(BucketLibUtil.addMilk(new ItemStack(universalBucketItem)));
                    this.matchingStacks.add(class_6880.method_40223(universalBucketItem));
                }
            });
        }
        return this.matchingStacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer implements CustomIngredientSerializer<MilkIngredient> {

        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 NAME = BucketLib.id("milk");

        public static final MapCodec<MilkIngredient> CODEC = MapCodec.of(Encoder.empty(), Decoder.unit(new MilkIngredient()));

        private static final class_9139<class_9129, MilkIngredient> PACKET_CODEC = class_9139.method_56437(
                MilkIngredient.Serializer::write,
                MilkIngredient.Serializer::read);

        private Serializer() {}

        @Override
        public class_2960 getIdentifier() {
            return NAME;
        }

        @Override
        public MapCodec<MilkIngredient> getCodec() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, MilkIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        private static MilkIngredient read(class_9129 buffer) {
            return new MilkIngredient();
        }

        private static void write(@Nonnull class_9129 buffer, @Nonnull MilkIngredient ingredient) {
        }
    }

}
