/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.platform.Services;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class FluidIngredient
implements CustomIngredient {
    protected final class_3611 fluid;
    protected final class_6862<class_3611> tag;
    private List<class_6880<class_1792>> matchingStacks;

    private FluidIngredient(class_3611 fluid, class_6862<class_3611> tag) {
        this.fluid = fluid;
        this.tag = tag;
    }

    public FluidIngredient(Optional<class_2960> fluidOptional, Optional<class_6862<class_3611>> tagOptional) {
        this(fluidOptional.map(arg_0 -> ((class_7922)class_7923.field_41173).method_10223(arg_0)).filter(Optional::isPresent).map(reference -> (class_3611)((class_6880.class_6883)reference.get()).comp_349()).orElse(null), (class_6862<class_3611>)((class_6862)tagOptional.orElse(null)));
    }

    public FluidIngredient(class_3611 fluid) {
        this(fluid, null);
    }

    public FluidIngredient(class_6862<class_3611> tag) {
        this((class_3611)null, tag);
    }

    private boolean isFluidCorrect(class_3611 fluid) {
        return fluid != null && (this.fluid != null && fluid.method_15780(this.fluid) || this.tag != null && fluid.method_15785().method_15767(this.tag));
    }

    public boolean test(class_1799 itemStack) {
        Iterator iterator;
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        class_2960 location = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        if ("mekanism".equals(location.method_12836()) && itemStack.getRecipeRemainder().method_7960()) {
            return false;
        }
        class_1799 container = itemStack.method_46651(1);
        Storage storage = (Storage)ContainerItemContext.withConstant((class_1799)container).find(FluidStorage.ITEM);
        StorageView fluidView = null;
        if (storage != null && (iterator = storage.nonEmptyViews().iterator()).hasNext()) {
            StorageView view;
            fluidView = view = (StorageView)iterator.next();
        }
        if (fluidView == null) {
            return false;
        }
        return this.isFluidCorrect(((FluidVariant)fluidView.getResource()).getFluid()) && fluidView.getAmount() == 81000L;
    }

    public List<class_6880<class_1792>> getMatchingItems() {
        if (this.matchingStacks == null) {
            this.matchingStacks = new ArrayList<class_6880<class_1792>>();
            ArrayList<class_3611> fluids = new ArrayList<class_3611>();
            if (this.tag != null) {
                class_7923.field_41173.method_40286(this.tag).forEach(fluid -> fluids.add((class_3611)fluid.comp_349()));
            } else if (this.fluid != null) {
                fluids.add(this.fluid);
            }
            for (class_3611 fluid2 : fluids) {
                class_1792 bucketItem = fluid2.method_15774();
                if (!(bucketItem instanceof class_1755) || Services.BUCKET.getFluidOfBucketItem((class_1755)bucketItem) != fluid2) continue;
                this.matchingStacks.add((class_6880<class_1792>)class_6880.method_40223((Object)bucketItem));
                BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                    if (universalBucketItem.canHoldFluid(fluid2)) {
                        this.matchingStacks.add((class_6880<class_1792>)class_6880.method_40223((Object)universalBucketItem));
                    }
                });
            }
        }
        return this.matchingStacks;
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    implements CustomIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 NAME = BucketLib.id("fluid");
        private static final MapCodec<FluidIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)class_2960.field_25139.optionalFieldOf("fluid").forGetter(i -> Optional.of(class_7923.field_41173.method_10221((Object)i.fluid))), (App)class_6862.method_40090((class_5321)class_7923.field_41173.method_46765()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, FluidIngredient::new));
        private static final class_9139<class_9129, FluidIngredient> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public class_2960 getIdentifier() {
            return NAME;
        }

        public MapCodec<FluidIngredient> getCodec() {
            return CODEC;
        }

        public class_9139<class_9129, FluidIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }

        @Nonnull
        private static FluidIngredient read(class_9129 buffer) {
            String fluid = buffer.method_19772();
            String tagId = buffer.method_19772();
            if (!tagId.isEmpty()) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)class_2960.method_60654((String)tagId));
                return new FluidIngredient((class_6862<class_3611>)tag);
            }
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a fluid ingredient with no fluid or tag.");
            }
            Optional fluidOptional = class_7923.field_41173.method_10223(class_2960.method_60654((String)fluid));
            if (fluidOptional.isEmpty()) {
                throw new IllegalArgumentException("Fluid resource location \"" + fluid + " \" could not be found.");
            }
            return new FluidIngredient((class_3611)((class_6880.class_6883)fluidOptional.get()).comp_349());
        }

        private static void write(@Nonnull class_9129 buffer, @Nonnull FluidIngredient ingredient) {
            buffer.method_10814(ingredient.fluid != null ? Objects.requireNonNull(class_7923.field_41173.method_10221((Object)ingredient.fluid)).toString() : "");
            buffer.method_10814(ingredient.tag != null ? ingredient.tag.comp_327().toString() : "");
        }
    }
}

