/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.item;

import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.UnmodifiableView;

public class StackItemContext
implements ContainerItemContext {
    private final SingleVariantStorage<ItemVariant> stackSlot = new SingleVariantStorage<ItemVariant>(this){

        protected ItemVariant getBlankVariant() {
            return ItemVariant.blank();
        }

        protected long getCapacity(ItemVariant variant) {
            return variant.getItem().method_7882();
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
            if (!this.isResourceBlank()) {
                return 0L;
            }
            this.variant = insertedVariant;
            this.amount = maxAmount;
            return maxAmount;
        }

        public long extract(ItemVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
            if (this.isResourceBlank() || extractedVariant.getItem() != ((ItemVariant)this.variant).getItem()) {
                return 0L;
            }
            long amountDiff = this.amount - maxAmount;
            if (amountDiff > 0L) {
                this.amount = amountDiff;
                return maxAmount;
            }
            this.variant = this.getBlankVariant();
            this.amount = 0L;
            return maxAmount + amountDiff;
        }
    };

    public StackItemContext(class_1799 stack) {
        this.stackSlot.variant = ItemVariant.of((class_1799)stack);
        this.stackSlot.amount = stack.method_7947();
    }

    public SingleSlotStorage<ItemVariant> getMainSlot() {
        return this.stackSlot;
    }

    public long insertOverflow(ItemVariant itemVariant, long maxAmount, TransactionContext transactionContext) {
        return 0L;
    }

    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getAdditionalSlots() {
        return List.of();
    }
}

