/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.item;

import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.FluidStorageData;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class UniversalBucketFluidStorage
extends SingleFluidStorage {
    private final ContainerItemContext context;

    public UniversalBucketFluidStorage(ContainerItemContext context) {
        this.context = context;
        Optional optional = context.getItemVariant().getComponents().method_57845(BucketLibMod.STORAGE);
        if (optional != null) {
            optional.ifPresent(data -> {
                if (!data.isEmpty()) {
                    this.variant = data.fluidVariant();
                    this.amount = data.amount();
                }
            });
        }
    }

    protected long getCapacity(FluidVariant variant) {
        return 81000L;
    }

    protected boolean canInsert(FluidVariant variant) {
        UniversalBucketItem universalBucketItem;
        class_1792 class_17922;
        class_1799 stack = this.context.getItemVariant().toStack();
        return ((FluidVariant)this.variant).isBlank() && BucketLibUtil.isEmpty(stack) && (class_17922 = this.context.getItemVariant().getItem()) instanceof UniversalBucketItem && (universalBucketItem = (UniversalBucketItem)class_17922).canHoldFluid(variant.getFluid());
    }

    protected boolean canExtract(FluidVariant variant) {
        class_1799 stack = this.context.getItemVariant().toStack();
        return ((FluidVariant)this.variant).getFluid() == variant.getFluid() && !BucketLibUtil.containsEntityType(stack) && !BucketLibUtil.containsMilk(stack);
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        if (maxAmount >= this.getCapacity() && (insertedVariant.equals((Object)this.variant) || ((FluidVariant)this.variant).isBlank()) && this.canInsert(insertedVariant)) {
            class_1799 stack = this.context.getItemVariant().toStack();
            stack.method_57379(BucketLibMod.STORAGE, (Object)new FluidStorageData(insertedVariant, this.getCapacity()));
            if (this.exchangeOrRemove(ItemVariant.of((class_1799)stack), transaction)) {
                return this.getCapacity();
            }
        }
        return 0L;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        class_1799 stack;
        class_1792 class_17922;
        StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
        if (maxAmount >= this.amount && extractedVariant.equals((Object)this.variant) && this.canExtract(extractedVariant) && (class_17922 = (stack = this.context.getItemVariant().toStack()).method_7909()) instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)class_17922;
            if (!bucketItem.isCracked(stack)) {
                if (BucketLibUtil.containsContent(stack)) {
                    BucketLibUtil.removeContentNoCopy(stack, null, null, false);
                }
                stack.method_57381(BucketLibMod.STORAGE);
                BucketLibUtil.damageByOne(stack, null);
            } else {
                stack.method_7934(1);
            }
            if (this.exchangeOrRemove(ItemVariant.of((class_1799)stack), transaction)) {
                return this.amount;
            }
        }
        return 0L;
    }

    private boolean exchangeOrRemove(ItemVariant newVariant, TransactionContext transaction) {
        if (!newVariant.isBlank()) {
            return this.context.exchange(newVariant, 1L, transaction) == 1L;
        }
        return this.context.extract(this.context.getItemVariant(), 1L, transaction) == 1L;
    }
}

