/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib;

import de.cech12.bucketlib.CommonLoader;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.crafting.BlockIngredient;
import de.cech12.bucketlib.api.crafting.EmptyIngredient;
import de.cech12.bucketlib.api.crafting.EntityIngredient;
import de.cech12.bucketlib.api.crafting.FluidIngredient;
import de.cech12.bucketlib.api.crafting.MilkIngredient;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.item.UniversalBucketDispenseBehaviour;
import de.cech12.bucketlib.item.crafting.BucketDyeingRecipe;
import de.cech12.bucketlib.item.crafting.BucketFillingShapedRecipe;
import de.cech12.bucketlib.item.crafting.BucketFillingShapelessRecipe;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.ColorUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bucketlib")
public class BucketLibMod {
    public static DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"bucketlib");
    public static DeferredRegister<IIngredientSerializer<?>> INGREDIENT_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.INGREDIENT_SERIALIZERS, (String)"bucketlib");
    private static final Logger LOGGER;
    private static final List<UniversalBucketItem> buckets;

    public BucketLibMod() {
        CommonLoader.init();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::addItemsToTabs);
        RECIPE_SERIALIZERS.register(eventBus);
        INGREDIENT_SERIALIZERS.register(eventBus);
    }

    public static List<UniversalBucketItem> getRegisteredBuckets() {
        return Collections.unmodifiableList(buckets);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BucketLibTags.init();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(imcMessage -> {
            ResourceLocation bucketLocation;
            if (!"bucketlib".equals(imcMessage.modId())) {
                LOGGER.warn("Bucket could not be registered. The mod id \"{}\" of the IMCMessage is not \"{}\"", (Object)imcMessage.modId(), (Object)"bucketlib");
                return;
            }
            if (!"register_bucket".equals(imcMessage.method())) {
                LOGGER.warn("Bucket could not be registered. The method \"{}\" of the IMCMessage is not \"{}\"", (Object)imcMessage.method(), (Object)"register_bucket");
                return;
            }
            Object patt5003$temp = imcMessage.messageSupplier().get();
            if (patt5003$temp instanceof ResourceLocation && (bucketLocation = (ResourceLocation)patt5003$temp) != null) {
                Item bucketItem = (Item)ForgeRegistries.ITEMS.getValue(bucketLocation);
                if (bucketItem == null) {
                    LOGGER.info("Bucket could not be registered. The given ResourceLocation \"{}\" does not match any registered item in Forge registry.", (Object)bucketLocation);
                    return;
                }
                if (bucketItem instanceof UniversalBucketItem) {
                    UniversalBucketItem bucket = (UniversalBucketItem)bucketItem;
                    this.registerBucket(bucket);
                } else {
                    LOGGER.info("Bucket could not be registered. The item \"{}\" is not a {}.", (Object)bucketLocation, (Object)UniversalBucketItem.class.getName());
                }
            } else {
                LOGGER.warn("Bucket could not be registered. The message supplier of the IMCMessage does not contain a ResourceLocation");
            }
        });
    }

    private void registerBucket(UniversalBucketItem bucket) {
        buckets.add(bucket);
        DispenserBlock.m_52672_((ItemLike)bucket, (DispenseItemBehavior)UniversalBucketDispenseBehaviour.getInstance());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().getItemColors().m_92689_((stack, layer) -> {
            Fluid fluid;
            if (layer == 0 && bucket.isDyeable()) {
                return ColorUtil.getColor(stack, bucket.getDefaultColor());
            }
            if (layer == 1 && (fluid = Services.FLUID.getContainedFluid(stack)) != Fluids.f_76191_) {
                return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
            }
            return -1;
        }, new ItemLike[]{bucket}));
    }

    private void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        buckets.forEach(bucket -> {
            if (event.getTabKey() == bucket.getCreativeTab()) {
                ItemStack emptyBucket = new ItemStack((ItemLike)bucket);
                event.m_246342_(emptyBucket);
                for (Fluid fluid : ForgeRegistries.FLUIDS) {
                    if (fluid == Fluids.f_76191_ || ForgeMod.MILK.isPresent() && ((Fluid)ForgeMod.MILK.get()).m_6212_(fluid) || !bucket.canHoldFluid(fluid)) continue;
                    event.m_246342_(BucketLibUtil.addFluid(emptyBucket, fluid));
                }
                event.m_246342_(BucketLibUtil.addMilk(emptyBucket));
                for (RegistryUtil.BucketEntity bucketEntity : RegistryUtil.getBucketEntities()) {
                    if (!bucket.canHoldEntity(bucketEntity.entityType()) || !bucket.canHoldFluid(bucketEntity.fluid())) continue;
                    ItemStack filledBucket = BucketLibUtil.addFluid(emptyBucket, bucketEntity.fluid());
                    filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity.entityType());
                    event.m_246342_(filledBucket);
                }
                for (RegistryUtil.BucketBlock bucketBlock : RegistryUtil.getBucketBlocks()) {
                    if (!bucket.canHoldBlock(bucketBlock.block())) continue;
                    event.m_246342_(BucketLibUtil.addBlock(emptyBucket, bucketBlock.block()));
                }
            }
        });
    }

    static {
        RECIPE_SERIALIZERS.register("bucket_dyeing", () -> BucketDyeingRecipe.Serializer.INSTANCE);
        RECIPE_SERIALIZERS.register("bucket_filling_shaped", () -> BucketFillingShapedRecipe.Serializer.INSTANCE);
        RECIPE_SERIALIZERS.register("bucket_filling_shapeless", () -> BucketFillingShapelessRecipe.Serializer.INSTANCE);
        INGREDIENT_SERIALIZERS.register("block", () -> BlockIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("empty", () -> EmptyIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("entity", () -> EntityIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("fluid", () -> FluidIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("milk", () -> MilkIngredient.SERIALIZER);
        LOGGER = LogManager.getLogger();
        buckets = new ArrayList<UniversalBucketItem>();
    }
}

