/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class BlockIngredient
extends AbstractIngredient {
    protected final Block block;
    protected final TagKey<Block> tag;
    private ItemStack[] matchingStacks;
    public static final Codec<BlockIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.optionalFieldOf("block").forGetter(i -> Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)i.block))), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, BlockIngredient::new));
    public static final IIngredientSerializer<BlockIngredient> SERIALIZER = new IIngredientSerializer<BlockIngredient>(){

        public Codec<? extends BlockIngredient> codec() {
            return CODEC;
        }

        public BlockIngredient read(FriendlyByteBuf buffer) {
            String block = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new BlockIngredient((TagKey<Block>)tag);
            }
            if (block.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a block ingredient with no block or tag.");
            }
            return new BlockIngredient((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(block)));
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull BlockIngredient ingredient) {
            buffer.m_130070_(ingredient.block != null ? Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)ingredient.block)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    };

    private BlockIngredient(Block block, TagKey<Block> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.block = block;
        this.tag = tag;
    }

    public BlockIngredient(Optional<ResourceLocation> blockOptional, Optional<TagKey<Block>> tagOptional) {
        this(blockOptional.map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getValue(arg_0)).orElse(null), (TagKey<Block>)((TagKey)tagOptional.orElse(null)));
    }

    public BlockIngredient(Block block) {
        this(block, null);
    }

    public BlockIngredient(TagKey<Block> tag) {
        this(null, tag);
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ITag blockIterator = this.block != null ? List.of(this.block) : Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(this.tag);
        for (Block block : blockIterator) {
            RegistryUtil.BucketBlock bucketBlock = RegistryUtil.getBucketBlock(block);
            if (bucketBlock == null) continue;
            if (itemStack.m_41720_() == bucketBlock.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getBlock(itemStack) == block;
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<Block> blocks = new ArrayList<Block>();
            ITagManager blockTags = ForgeRegistries.BLOCKS.tags();
            if (this.tag != null && blockTags != null) {
                blockTags.getTag(this.tag).forEach(blocks::add);
            } else if (this.block != null) {
                blocks.add(this.block);
            }
            List<RegistryUtil.BucketBlock> bucketBlocks = RegistryUtil.getBucketBlocks().stream().filter(bucketBlock -> blocks.contains(bucketBlock.block())).toList();
            for (RegistryUtil.BucketBlock bucketBlock2 : bucketBlocks) {
                stacks.add(new ItemStack((ItemLike)bucketBlock2.bucketItem()));
            }
            for (RegistryUtil.BucketBlock bucketBlock2 : bucketBlocks) {
                BucketLibMod.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldBlock(bucketBlock2.block())) {
                        stacks.add(BucketLibUtil.addBlock(new ItemStack((ItemLike)bucket), bucketBlock2.block()));
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

