/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class EmptyIngredient
extends AbstractIngredient {
    protected Item item;
    protected TagKey<Item> tag;
    private ItemStack[] matchingStacks;
    public static final Codec<EmptyIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.optionalFieldOf("item").forGetter(i -> Optional.ofNullable(ForgeRegistries.ITEMS.getKey((Object)i.item))), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, EmptyIngredient::new));
    public static final IIngredientSerializer<EmptyIngredient> SERIALIZER = new IIngredientSerializer<EmptyIngredient>(){

        public Codec<? extends EmptyIngredient> codec() {
            return CODEC;
        }

        public EmptyIngredient read(FriendlyByteBuf buffer) {
            String item = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!item.isEmpty()) {
                return new EmptyIngredient((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item)));
            }
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new EmptyIngredient((TagKey<Item>)tag);
            }
            return new EmptyIngredient();
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull EmptyIngredient ingredient) {
            buffer.m_130070_(ingredient.item != null ? Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.item)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    };

    public EmptyIngredient(Item item, TagKey<Item> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.item = item;
        this.tag = tag;
    }

    public EmptyIngredient(Item item) {
        this(item, null);
    }

    public EmptyIngredient(TagKey<Item> tag) {
        this(null, tag);
    }

    public EmptyIngredient() {
        this((Item)null, null);
    }

    public EmptyIngredient(Optional<ResourceLocation> itemOptional, Optional<TagKey<Item>> tagOptional) {
        this(itemOptional.map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).orElse(null), (TagKey<Item>)((TagKey)tagOptional.orElse(null)));
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (this.item == null && this.tag == null && itemStack.m_41720_() == Items.f_42446_) {
            return true;
        }
        if (this.item != null && itemStack.m_41720_() == this.item || this.tag != null && itemStack.m_204117_(this.tag) || this.item == null && this.tag == null && itemStack.m_41720_() instanceof UniversalBucketItem) {
            return BucketLibUtil.isEmpty(itemStack);
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (this.item == null && this.tag == null) {
                stacks.add(new ItemStack((ItemLike)Items.f_42446_));
            }
            BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                ItemStack universalBucketItemStack = new ItemStack((ItemLike)universalBucketItem);
                if (this.item != null && universalBucketItem == this.item || this.tag != null && universalBucketItemStack.m_204117_(this.tag) || this.item == null && this.tag == null) {
                    stacks.add(universalBucketItemStack);
                }
            });
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

