/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.util.BucketLibUtil;
import de.cech12.bucketlib.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class EntityIngredient
extends AbstractIngredient {
    protected final EntityType<?> entityType;
    protected final TagKey<EntityType<?>> tag;
    private ItemStack[] matchingStacks;
    public static final Codec<EntityIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.optionalFieldOf("entity").forGetter(i -> Optional.ofNullable(ForgeRegistries.ENTITY_TYPES.getKey(i.entityType))), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, EntityIngredient::new));
    public static final IIngredientSerializer<EntityIngredient> SERIALIZER = new IIngredientSerializer<EntityIngredient>(){

        public Codec<? extends EntityIngredient> codec() {
            return CODEC;
        }

        public EntityIngredient read(FriendlyByteBuf buffer) {
            String block = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new EntityIngredient(tag);
            }
            if (block.isEmpty()) {
                throw new IllegalArgumentException("Cannot create an entity ingredient with no entity or tag.");
            }
            return new EntityIngredient((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(block)));
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull EntityIngredient ingredient) {
            buffer.m_130070_(ingredient.entityType != null ? Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(ingredient.entityType)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    };

    private EntityIngredient(EntityType<?> entityType, TagKey<EntityType<?>> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.entityType = entityType;
        this.tag = tag;
    }

    public EntityIngredient(Optional<ResourceLocation> entityTypeOptional, Optional<TagKey<EntityType<?>>> tagOptional) {
        this((EntityType<?>)entityTypeOptional.map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(arg_0)).orElse(null), (TagKey<EntityType<?>>)tagOptional.orElse(null));
    }

    public EntityIngredient(EntityType<?> entityType) {
        this(entityType, null);
    }

    public EntityIngredient(TagKey<EntityType<?>> tag) {
        this(null, tag);
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ITag entityTypeIterator = this.entityType != null ? List.of(this.entityType) : Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).getTag(this.tag);
        for (EntityType entityType : entityTypeIterator) {
            RegistryUtil.BucketEntity bucketEntity = RegistryUtil.getBucketEntity(entityType);
            if (bucketEntity == null) continue;
            if (itemStack.m_41720_() == bucketEntity.bucketItem()) {
                return true;
            }
            return BucketLibUtil.getEntityType(itemStack) == entityType;
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList entityTypes = new ArrayList();
            ITagManager entityTypeTags = ForgeRegistries.ENTITY_TYPES.tags();
            if (this.tag != null && entityTypeTags != null) {
                entityTypeTags.getTag(this.tag).forEach(entityTypes::add);
            } else if (this.entityType != null) {
                entityTypes.add(this.entityType);
            }
            List<RegistryUtil.BucketEntity> bucketEntities = RegistryUtil.getBucketEntities().stream().filter(bucketEntity -> entityTypes.contains(bucketEntity.entityType())).toList();
            for (RegistryUtil.BucketEntity bucketEntity2 : bucketEntities) {
                stacks.add(new ItemStack((ItemLike)bucketEntity2.bucketItem()));
            }
            for (RegistryUtil.BucketEntity bucketEntity2 : bucketEntities) {
                BucketLibMod.getRegisteredBuckets().forEach(bucket -> {
                    if (bucket.canHoldFluid(bucketEntity2.fluid()) && bucket.canHoldEntity(bucketEntity2.entityType())) {
                        ItemStack filledBucket = new ItemStack((ItemLike)bucket);
                        if (bucketEntity2.fluid() != Fluids.f_76191_) {
                            filledBucket = BucketLibUtil.addFluid(filledBucket, bucketEntity2.fluid());
                        }
                        filledBucket = BucketLibUtil.addEntityType(filledBucket, bucketEntity2.entityType());
                        stacks.add(filledBucket);
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

