/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITagManager;

public class FluidIngredient
extends AbstractIngredient {
    protected final Fluid fluid;
    protected final TagKey<Fluid> tag;
    private ItemStack[] matchingStacks;
    public static final Codec<FluidIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.f_135803_.optionalFieldOf("fluid").forGetter(i -> Optional.ofNullable(ForgeRegistries.FLUIDS.getKey((Object)i.fluid))), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, FluidIngredient::new));
    public static final IIngredientSerializer<FluidIngredient> SERIALIZER = new IIngredientSerializer<FluidIngredient>(){

        public Codec<? extends FluidIngredient> codec() {
            return CODEC;
        }

        public FluidIngredient read(FriendlyByteBuf buffer) {
            String fluid = buffer.m_130277_();
            String tagId = buffer.m_130277_();
            if (!tagId.isEmpty()) {
                TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
                return new FluidIngredient((TagKey<Fluid>)tag);
            }
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Cannot create a fluid ingredient with no fluid or tag.");
            }
            return new FluidIngredient((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)));
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull FluidIngredient ingredient) {
            buffer.m_130070_(ingredient.fluid != null ? Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)ingredient.fluid)).toString() : "");
            buffer.m_130070_(ingredient.tag != null ? ingredient.tag.f_203868_().toString() : "");
        }
    };

    private FluidIngredient(Fluid fluid, TagKey<Fluid> tag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.fluid = fluid;
        this.tag = tag;
    }

    public FluidIngredient(Optional<ResourceLocation> fluidOptional, Optional<TagKey<Fluid>> tagOptional) {
        this(fluidOptional.map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).orElse(null), (TagKey<Fluid>)((TagKey)tagOptional.orElse(null)));
    }

    public FluidIngredient(Fluid fluid) {
        this(fluid, null);
    }

    public FluidIngredient(TagKey<Fluid> tag) {
        this((Fluid)null, tag);
    }

    private boolean isFluidCorrect(Fluid fluid) {
        return fluid != null && (this.fluid != null && fluid.m_6212_(this.fluid) || this.tag != null && fluid.m_76145_().m_205070_(this.tag));
    }

    public boolean test(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (location != null && "mekanism".equals(location.m_135827_()) && itemStack.getCraftingRemainingItem().m_41619_()) {
            return false;
        }
        ItemStack container = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
        Optional drainedFluidOptional = FluidUtil.getFluidHandler((ItemStack)container).map(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        if (drainedFluidOptional.isPresent() && !((FluidStack)drainedFluidOptional.get()).isEmpty()) {
            FluidStack drainedFluid = (FluidStack)drainedFluidOptional.get();
            return this.isFluidCorrect(drainedFluid.getFluid()) && drainedFluid.getAmount() == 1000;
        }
        return false;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<Fluid> fluids = new ArrayList<Fluid>();
            ITagManager fluidTags = ForgeRegistries.FLUIDS.tags();
            if (this.tag != null && fluidTags != null) {
                fluidTags.getTag(this.tag).forEach(fluids::add);
            } else if (this.fluid != null) {
                fluids.add(this.fluid);
            }
            for (Fluid fluid : fluids) {
                Item bucketItem = fluid.m_6859_();
                if (!(bucketItem instanceof BucketItem) || ((BucketItem)bucketItem).getFluid() != fluid) continue;
                stacks.add(new ItemStack((ItemLike)bucketItem));
                BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                    if (universalBucketItem.canHoldFluid(fluid)) {
                        stacks.add(BucketLibUtil.addFluid(new ItemStack((ItemLike)universalBucketItem), fluid));
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return this.matchingStacks;
    }

    public boolean m_43947_() {
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> serializer() {
        return SERIALIZER;
    }
}

